#pragma once
#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/billing/interfaces/account.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TRTSessionsRefreshWatcher: public IRTRegularBackgroundProcess {
    R_READONLY(TDuration, ExpirationDelta, TDuration::Minutes(10));
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTSessionsRefreshWatcher> Registrator;
public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "ya_auto_sessions_refresh";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
