#pragma once

#include <drive/backend/rt_background/common/database.h>

#include <ydb/public/sdk/cpp/client/ydb_value/value.h>

#include <rtline/library/storage/ydb/structured.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/yexception.h>

class TRTYdbDumperState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTYdbDumperState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTYdbDumperWatcher
    : public TDBTableScanner
{
private:
    using TBase = TDBTableScanner;
    static TFactory::TRegistrator<TRTYdbDumperWatcher> Registrator;

public:
    using TBase::TBase;
    using EPrimitiveType = NYdb::EPrimitiveType;
    using TSchema = TMap<TString, EPrimitiveType>;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "ydb_dumper_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    virtual bool ProcessRecords(const TRecordsSet& records, const NDrive::IServer& server, ui64& lastEventId, TMessagesCollector& errors) const override;
    virtual TRTHistoryWatcherState* BuildState() const override {
        return new TRTYdbDumperState();
    }

    TSchema GetEntitySchema() const;
    TSchema GetHistorySchema() const;
    TString MakeHeader(const TSet<TString>& columnNames) const;
    bool CheckSchema(const TRecordsSet& records, const TSchema& schema) const;
    TString ConvertTypes(const TSet<TString>& columnNames, const NStorage::TTableRecord& record, const TSchema& schema, NStorage::ITransaction* tx) const;

    void DumpHistoryData(NStorage::IDatabase::TPtr destinationDatabase, const TRecordsSet& records, ui64& lastEventId) const;
    void DumpEntityData(NStorage::IDatabase::TPtr sourceDatabase, NStorage::IDatabase::TPtr destinationDatabase, const TRecordsSet& records) const;

    TString MakeUpsertQuery(const TRecordsSet& records, const TString& tableName, const TSchema& schema, NStorage::ITransaction::TPtr tx) const;
    TString MakeDeleteQuery(const TString& tableName, const TSet<TString>& tagIds, NStorage::ITransaction::TPtr tx) const;
    TRecordsSet GetTags(const TSet<TString>& tagIds, NStorage::ITransaction::TPtr tx, const TString& tableName) const;

private:
    R_FIELD(TString, DBType);
    R_FIELD(TString, DestinationDBName);
    R_FIELD(TString, DestinationTableName);
    R_OPTIONAL(TString, DestinationEntityTableName);
    R_OPTIONAL(TString, SourceEntityTableName);
};
