#pragma once
#include <drive/backend/rt_background/common/database.h>
#include <drive/backend/rt_background/common/yt.h>
#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/billing/exports/yt_nodes.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TRTYTDumperState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTYTDumperState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTYTDumperWatcher
    : public TDBTableScanner
    , public TYtProcessTraits
{
private:
    using TBase = TDBTableScanner;
    static TFactory::TRegistrator<TRTYTDumperWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "yt_dumper_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    NYT::TTableSchema GetYtSchema() const;
    void DumpToYtNode(const NStorage::TTableRecord& tableRecord, NYT::TNode& recordNode, const NDrive::IServer& server) const;
    virtual bool ProcessRecords(const TRecordsSet& records, const NDrive::IServer& server, ui64& lastEventId, TMessagesCollector& errors) const override;
    virtual TRTHistoryWatcherState* BuildState() const override {
        return new TRTYTDumperState();
    }
private:
    R_FIELD(TString, YTCluster);
    R_FIELD(TString, YTDir);
    R_FIELD(TString, DBType);
    R_FIELD(bool, DBDefineSchema, false);
};
