#include "api.h"

TRTLineAPI::TRTLineAPI(
    const TRTLineAPIConfig& config, TMaybe<NDrive::TTvmAuth> tvmAuth
)
    : Config(config)
{
    NRTLine::TNehSearchClient::TEndpoint endpoint(Config.GetHost(), Config.GetPort());
    endpoint.SetBalancerOptions(Config.GetBalancerOptions());
    endpoint.SetService(Config.GetServiceName());
    SearchClient = MakeHolder<NRTLine::TNehSearchClient>(
        endpoint, Config.GetSearchRequestConfig(), tvmAuth,
        Config.GetSpMetaSearch()
    );
    if (Config.GetIndexingHost()) {
        IndexingClient = MakeHolder<NRTLine::TNehIndexingClient>(
            Config.GetIndexingToken(), Config.GetIndexingHost(),
            Config.GetIndexingPort(), Config.GetIndexingRequestConfig()
        );
    }
}

const NRTLine::TNehSearchClient& TRTLineAPI::GetSearchClient() const {
    return *SearchClient;
}

const NRTLine::TNehIndexingClient* TRTLineAPI::GetIndexingClient() const {
    return IndexingClient.Get();
}
