#pragma once

#include "config.h"

#include <rtline/api/search_client/neh_client.h>
#include <rtline/api/indexing_client/neh_client.h>

#include <library/cpp/yconf/conf.h>


class TRTLineAPI {
private:
    TRTLineAPIConfig Config;
    THolder<NRTLine::TNehSearchClient> SearchClient;
    THolder<NRTLine::TNehIndexingClient> IndexingClient;

public:
    TRTLineAPI(const TRTLineAPIConfig& config, TMaybe<NDrive::TTvmAuth> tvmAuth);

    const NRTLine::TNehSearchClient& GetSearchClient() const;
    const NRTLine::TNehIndexingClient* GetIndexingClient() const;
};
