#pragma once

#include <rtline/api/search_client/neh_client.h>
#include <rtline/api/indexing_client/neh_client.h>

#include <library/cpp/yconf/conf.h>

class TRTLineAPIConfig {
private:
    R_FIELD(TString, Host);
    R_FIELD(ui16, Port, 0);
    R_FIELD(TString, ServiceName);
    R_FIELD(TString, RequestPolicyName);
    R_FIELD(NRTLine::TRequestBuilder::TBalancerOptions, BalancerOptions);
    R_FIELD(NSimpleMeta::TConfig, SearchRequestConfig);
    R_FIELD(ui32, SelfClientId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);
    R_FIELD(TString, SpMetaSearch);

    R_FIELD(TString, IndexingHost);
    R_FIELD(ui16, IndexingPort, 0);
    R_FIELD(TString, IndexingToken);
    R_FIELD(TString, IndexingPolicyName);
    R_FIELD(NSimpleMeta::TConfig, IndexingRequestConfig);

public:
    TRTLineAPIConfig();
    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;
};
