#!/bin/bash

mkdir -p /work/secrets/chats_db_password
mkdir -p /work/secrets/disk_token
mkdir -p /work/secrets/drive_keys
mkdir -p /work/secrets/drive_push_token
mkdir -p /work/secrets/drive-avtokod_token
mkdir -p /work/secrets/major_password
mkdir -p /work/secrets/s3mds
mkdir -p /work/secrets/octopus_token
mkdir -p /work/secrets/renins_secrets
mkdir -p /work/secrets/self_http_requester
mkdir -p /work/secrets/send-push-token
mkdir -p /work/secrets/sensitive_data_hash_key
mkdir -p /work/secrets/solomon_token
mkdir -p /work/secrets/staff_secrets
mkdir -p /work/secrets/startrek_secret_key
mkdir -p /work/secrets/takeout_tvm
mkdir -p /work/secrets/taxi-routeinfo
mkdir -p /work/secrets/telephony_secrets
mkdir -p /work/secrets/user_document_photos
mkdir -p /work/secrets/weather_auth
mkdir -p /work/secrets/yang
mkdir -p /work/secrets/tanker_api_prod_service_key

DB_PASSWORD=$(grep 'db.yandex.net' /etc/yandex/taxi-secdist/taxi.json | grep password | sed -E 's/.*password\=([a-zA-Z0-9_]+).*/\1/')
TVM_SECRET=$(python3 -c 'import json;secdist=json.load(open("/etc/yandex/taxi-secdist/taxi.json"));print(secdist["settings_override"]["TVM_SERVICES"]["scooter-backend"]["secret"]);')
S3MDS_ACCESS_KEY_ID=$(python3 -c 'import json;secdist=json.load(open("/etc/yandex/taxi-secdist/taxi.json"));print(secdist["settings_override"]["S3MDS_TAXI_DRIVERS_SCOOTER_BACKEND"]["access_key_id"]);')
S3MDS_ACCESS_SECRET_KEY=$(python3 -c 'import json;secdist=json.load(open("/etc/yandex/taxi-secdist/taxi.json"));print(secdist["settings_override"]["S3MDS_TAXI_DRIVERS_SCOOTER_BACKEND"]["secret_key"]);')

echo $DB_PASSWORD > /work/secrets/chats_db_password/chats_db_password
echo $DB_PASSWORD > /work/secrets/drive_keys/CarsharingDBPasswordProd
echo $DB_PASSWORD > /work/secrets/drive-prestable_drive_db-telematics-password
echo $DB_PASSWORD > /work/secrets/drive-prod_drive_db-telematics-password

echo $TVM_SECRET > /work/secrets/drive_keys/TVMSecret

echo $S3MDS_ACCESS_KEY_ID > /work/secrets/s3mds/access_key_id
echo $S3MDS_ACCESS_SECRET_KEY > /work/secrets/s3mds/access_secret_key

echo "token" > /work/secrets/disk_token/disk_token
echo "token" > /work/secrets/drive_push_token/subscription_token
echo "token" > /work/secrets/drive-avtokod_token/AvtokodToken
echo "token" > /work/secrets/major_password/major_password
echo "token" > /work/secrets/octopus_token/octopus_token
echo "token" > /work/secrets/renins_secrets/renins_password
echo "token" > /work/secrets/self_http_requester/auth_header
echo "token" > /work/secrets/send-push-token/key
echo "00000000000000000000000000000000" > /work/secrets/sensitive_data_hash_key/sensitive_data_hash_key
echo "token" > /work/secrets/solomon_token/token
echo "token" > /work/secrets/staff_secrets/staff_token
echo "token" > /work/secrets/startrek_secret_key/CARSHARING_STARTREK_TOKEN
echo "token" > /work/secrets/takeout_tvm/key
echo "token" > /work/secrets/takeout_tvm/key
echo "token" > /work/secrets/taxi-routeinfo/ApiKey
echo "token" > /work/secrets/telephony_secrets/CARSHARING_CALLCENTER_SECRET_KEY
echo "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" > /work/secrets/user_document_photos/key
echo "token" > /work/secrets/weather_auth/weather_auth
echo "token" > /work/secrets/yang/token
echo "token" > /work/secrets/IngosPass
echo "token" > /work/secrets/tanker_api_prod_key
echo "{}" > /work/call.json
echo "token" > /work/secrets/tanker_api_prod_service_key/API_new_tanker
