#include "alloc.h"

#include <kernel/daemon/daemon.h>
#include <tcmalloc/malloc_extension.h>

#include <thread>

namespace NDrive {

void ConfigureAllocator() {
    // inspired by https://a.yandex-team.ru/arcadia/yt/yt/ytlib/program/program.cpp?rev=r9716776#L352

    if (tcmalloc::MallocExtension::NeedsProcessBackgroundActions()) {
        std::thread backgroundThread([] {
            TThread::SetCurrentThreadName("ProcessBackgroundActions");
            tcmalloc::MallocExtension::ProcessBackgroundActions();
            Y_ENSURE(false, "ProcessBackgroundActions must never exit");
        });
        backgroundThread.detach();
    }

    tcmalloc::MallocExtension::SetProfileSamplingRate(2_MB);
    tcmalloc::MallocExtension::SetGuardedSamplingRate(128_MB);
    tcmalloc::MallocExtension::ActivateGuardedSampling();
    tcmalloc::MallocExtension::SetMaxPerCpuCacheSize(3_MB);
    tcmalloc::MallocExtension::SetMaxTotalThreadCacheBytes(24_MB);
    tcmalloc::MallocExtension::SetBackgroundReleaseRate(tcmalloc::MallocExtension::BytesPerSecond{32_MB});
    tcmalloc::MallocExtension::EnableForkSupport();
}

} // namespace NDrive
