#pragma once

#include <drive/backend/abstract/notifier.h>
#include <drive/backend/auth/common/auth.h>
#include <drive/backend/background/manager/manager.h>
#include <drive/backend/base/config.h>
#include <drive/backend/chat_robots/configuration/config.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/device_snapshot/config/config.h>
#include <drive/backend/doc_packages/manager.h>
#include <drive/backend/fueling_manager/fueling_manager.h>
#include <drive/backend/notifications/mail/binder.h>
#include <drive/backend/parking_zones/manager.h>
#include <drive/backend/promo_codes/manager.h>
#include <drive/backend/radar/radar_geohash.h>
#include <drive/backend/registrar/config.h>
#include <drive/backend/rt_background/manager/manager.h>
#include <drive/backend/saas/api.h>
#include <drive/backend/support_center/config.h>
#include <drive/backend/surge/config.h>
#include <drive/backend/user_devices/manager.h>
#include <drive/backend/users/user_documents_check.h>
#include <drive/backend/users_controller/ucontroller.h>

#include <drive/library/cpp/balance/client.h>
#include <drive/library/cpp/clck/client.h>
#include <drive/library/cpp/clear_web/client.h>
#include <drive/library/cpp/clickhouse/options.h>
#include <drive/library/cpp/covid_pass/client.h>
#include <drive/library/cpp/searchserver/http_status_config.h>
#include <drive/library/cpp/saturn/config.h>
#include <drive/library/cpp/self_requester/client.h>
#include <drive/library/cpp/sendr/client.h>
#include <drive/library/cpp/social_api/config.h>
#include <drive/library/cpp/taxi/antifraud/client.h>
#include <drive/library/cpp/taxi/chat/client.h>
#include <drive/library/cpp/taxi/driver_profiles/client.h>
#include <drive/library/cpp/taxi/driver_status/client.h>
#include <drive/library/cpp/taxi/fleet_vehicles/client.h>
#include <drive/library/cpp/taxi/promocodes/config.h>
#include <drive/library/cpp/taxi/scooters_surge/config.h>
#include <drive/library/cpp/taxi/signalq_drivematics_api/client.h>
#include <drive/library/cpp/renins/client.h>
#include <drive/library/cpp/support_ai/client.h>
#include <drive/library/cpp/taxi/support_chat_suggest/client.h>
#include <drive/library/cpp/taxi/surge_calculator/config.h>
#include <drive/library/cpp/trust/lpm.h>
#include <drive/library/cpp/weather/config.h>
#include <drive/library/cpp/yadoc/config.h>
#include <drive/library/cpp/taxi/driver_trackstory/config.h>
#include <drive/library/cpp/yang/client.h>

#include <kernel/daemon/config/config_constructor.h>
#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/yconf/conf.h>

#include <rtline/api/search_client/client.h>
#include <rtline/library/executor/executor.h>
#include <rtline/library/storage/structured.h>

#include <util/stream/output.h>

class IDistributingBlockEventsStorageConfig;
class TTagsManagerConfig;
class TTaxiModuleConfig;
class TTelematicsClientConfig;

namespace NDrive {
    class TUserEventsApiConfig;
}

namespace NDrive::NChat {
    class TEngineConfig;
}

namespace NDrive {

class THttpRewriteConfig {
public:
    // Pattern should contain pattern for request path.
    TString Pattern;
    // Method should contain "GET" or "POST" method.
    TString Method = "GET";
    // HandlerPath should contain handler paths.
    TString HandlerPath;
    // OverrideQuery should contain overrides for query.
    TString OverrideQuery;

    void Init(const TYandexConfig::Directives& directives);
    void ToString(IOutputStream& os) const;
};

class TServerConfig: public TServerBaseConfig {
public:
    struct TGeobaseConfig {
        TString Path;
    };
    struct TGeoFeaturesConfig {
        TString Name;
    };
    struct TModelsStorageConfig {
        TString Name;
    };
    struct TTaxiRouteHistoryConfig {
        TString Endpoint;
        ui32 DestinationClientId = 0;
        ui32 SelfClientId = 0;
    };
    struct TTaxiSuggestConfig {
        ui32 SelfClientId = 0;
    };
    struct TTaxiSupportClassifierConfig {
        ui32 SelfClientId = 0;
    };

    using TSensorHistoryConfig = NClickHouse::TAsyncClientOptions;
    using TTrackClientConfig = NClickHouse::TAsyncClientOptions;
    using TRidesInfoConfig = NClickHouse::TAsyncClientOptions;

public:
    R_READONLY(TDuration, DevicesSnapshotWaitTime, TDuration::Minutes(1));
    R_READONLY(bool, TransactionNamesEnabled, false);
    R_READONLY(TString, YangClientType, "yang");

private:
    using TBase = TServerBaseConfig;

private:
    THolder<NDrive::NChat::TEngineConfig> ChatConfig;
    THolder<TTaskExecutorConfig> TelematicsApiConfig;
    THolder<TTelematicsClientConfig> TelematicsClientConfig;
    THolder<TFuelingManagerConfig> FuelingManagerConfig;
    THolder<TDriveAPIConfig> DriveAPIConfig;
    THolder<TUsersControllerConfig> UsersControllerConfig;
    THolder<TSurgeConstructorConfig> SurgeConstructorConfig;
    THolder<TSensorApiConfig> SensorApiConfig;
    THolder<TSensorHistoryConfig> SensorHistoryConfig;
    THolder<TRidesInfoConfig> RidesInfoConfig;
    THolder<TTrackClientConfig> TrackClientConfig;
    THolder<TWeatherAPIConfig> WeatherAPIConfig;
    THolder<TModelsStorageConfig> ModelsStorageConfig;
    THolder<TChatRobotsConfig> ChatRobotsConfig;
    THolder<IUserDevicesManagerConfig> UserDevicesManagerConfig;
    THolder<TUserRegistrationManagerConfig> UserRegistrationManagerConfig;
    THolder<NDrive::TUserEventsApiConfig> UserEventsApiConfig;
    THolder<NDrive::TUserEventsApiConfig> FeaturesClientConfig;
    THolder<TPromoCodesManagerConfig> PromoCodesManagerConfig;
    THolder<NDrive::TParkingZonesManagerConfig> ParkingZonesManagerConfig;
    THolder<TSupportCenterManagerConfig> SupportCenterManagerConfig;
    THolder<TSocialAPIClientConfig> SocialAPIClientConfig;
    THolder<TGeoFeaturesConfig> GeoFeaturesConfig;
    THolder<TTaxiSuggestConfig> TaxiSuggestConfig;
    THolder<TTaxiSupportClassifierConfig> TaxiSupportClassifierConfig;
    THolder<TTaxiSupportChatSuggestConfig> TaxiSupportChatSuggestConfig;
    THolder<TAccountEmailBinderConfig> AccountEmailBinderConfig;
    THolder<TSelfHttpRequesterConfig> SelfHttpRequesterConfig;
    THolder<TDocumentsManagerConfig> DocumentsManagerConfig;
    THolder<TTagsManagerConfig> TagsManagerConfig;
    THolder<TCovidPassMoscowConfig> CovidPassMoscowConfig;
    THolder<TCovidPassMoscowRegionConfig> CovidPassMoscowRegionConfig;
    THolder<TCovidPassGosuslugiConfig> CovidPassGosuslugiConfig;
    THolder<TClckClientConfig> ClckClientConfig;
    THolder<TTaxiChatClientConfig> TaxiChatClientConfig;
    THolder<TTaxiModuleConfig> TaxiRouteInfoClientConfig;
    THolder<TTaxiRouteHistoryConfig> TaxiRouteHistoryClientConfig;
    THolder<TGeobaseConfig> GeobaseConfig;
    THolder<TBalanceClientConfig> BalanceClientConfig;
    THolder<TYaDocClientConfig> YaDocClientConfig;
    THolder<IDistributingBlockEventsStorageConfig> DistributingBlockEventsStorageConfig;
    THolder<TSendrConfig> SendrConfig;
    THolder<TClearWebClientConfig> ClearWebClientConfig;
    THolder<NDrive::TScootersSurgeConfig> ScootersSurgeConfig;
    THolder<NDrive::TTaxiSurgeCalculatorConfig> TaxiSurgeCalculatorConfig;
    THolder<NDrive::TSaturnClientConfig> SaturnClientConfig;
    THolder<TTaxiAntifraudConfig> TaxiAntifraudConfig;
    THolder<TTaxiDriverProfilesConfig> TaxiDriverProfilesConfig;
    THolder<TTaxiDriverStatusConfig> TaxiDriverStatusConfig;
    THolder<TTaxiSignalqDrivematicsApiConfig> TaxiSignalqDrivematicsApiConfig;
    THolder<TTaxiFleetVehiclesConfig> TaxiFleetVehiclesConfig;
    THolder<TLPMClientConfig> LPMClientConfig;
    THolder<TUserDocumentsCheckConfig> UserDocumentsChecksConfig;
    THolder<TDBEntitiesManagerConfig> RadarGeohashConfig;
    THolder<TDBEntitiesManagerConfig> YDBConfig;
    THolder<NDrive::TParkingAggregatorsManagerConfig> ParkingConfig;
    THolder<NDevicesSnapshotManager::TOptions> DevicesSnapshotManagerConfig;
    THolder<TTaxiTrackStoryConfig> TaxiTrackStoryConfig;
    THolder<NDrive::TSupportAIApiConfig> SupportAIApiConfig;
    THolder<TYangClientConfig> YangClientConfig;
    THolder<NDrive::NRenins::TReninsConfig> ReninsApiKaskoConfig;
    TVector<THttpRewriteConfig> ProcessorRewritesConfig;
    THolder<NDrive::TTaxiPromocodesClientConfig> TaxiPromocodesClientConfig;

protected:
    void Init(const TYandexConfig::Section* section);
    virtual void DoToString(IOutputStream& os) const override;

public:
    TServerConfig(const TServerConfigConstructorParams& params);
    ~TServerConfig();

    const TLPMClientConfig* GetLPMClientConfig() const {
        return LPMClientConfig.Get();
    }

    const NDrive::NChat::TEngineConfig* GetChatConfig() const {
        return ChatConfig.Get();
    }

    const TTaskExecutorConfig* GetTelematicsApiConfig() const {
        return TelematicsApiConfig.Get();
    }

    const TTelematicsClientConfig* GetTelematicsClientConfig() const {
        return TelematicsClientConfig.Get();
    }

    const TSensorApiConfig* GetSensorApiConfig() const {
        return SensorApiConfig.Get();
    }

    const TSensorHistoryConfig* GetSensorHistoryConfig() const {
        return SensorHistoryConfig.Get();
    }

    const TRidesInfoConfig* GetRidesInfoConfig() const {
        return RidesInfoConfig.Get();
    }

    const TSurgeConstructorConfig* GetSurgeConstructorConfig() const {
        return SurgeConstructorConfig.Get();
    }

    const TTrackClientConfig* GetTrackClientConfig() const {
        return TrackClientConfig.Get();
    }

    const TUsersControllerConfig* GetUsersControllerConfig() const {
        return UsersControllerConfig.Get();
    }

    const TFuelingManagerConfig* GetFuelingManagerConfig() const {
        return FuelingManagerConfig.Get();
    }

    const TDriveAPIConfig* GetDriveAPIConfig() const {
        return DriveAPIConfig.Get();
    }

    const TWeatherAPIConfig* GetWeatherAPIConfig() const {
        return WeatherAPIConfig.Get();
    }

    const TModelsStorageConfig* GetModelsStorageConfig() const {
        return ModelsStorageConfig.Get();
    }

    const TChatRobotsConfig* GetChatRobotsConfig() const {
        return ChatRobotsConfig.Get();
    }

    const IUserDevicesManagerConfig* GetUserDevicesManagerConfig() const {
        return UserDevicesManagerConfig.Get();
    }

    const TUserRegistrationManagerConfig* GetUserRegistrationManagerConfig() const {
        return UserRegistrationManagerConfig.Get();
    }

    const NDrive::TUserEventsApiConfig* GetUserEventsApiConfig() const {
        return UserEventsApiConfig.Get();
    }

    const NDrive::TUserEventsApiConfig* GetFeaturesClientConfig() const;

    const TPromoCodesManagerConfig* GetPromoCodesManagerConfig() const {
        return PromoCodesManagerConfig.Get();
    }

    const NDrive::TParkingZonesManagerConfig* GetParkingZonesManagerConfig() const {
        return ParkingZonesManagerConfig.Get();
    }

    const TSupportCenterManagerConfig* GetSupportCenterManagerConfig() const {
        return SupportCenterManagerConfig.Get();
    }

    const TSocialAPIClientConfig* GetSocialAPIClientConfig() const {
        return SocialAPIClientConfig.Get();
    }

    const TTaxiSuggestConfig* GetTaxiSuggestConfig() const {
        return TaxiSuggestConfig.Get();
    }

    const TTaxiSupportClassifierConfig* GetTaxiSupportClassifierConfig() const {
        return TaxiSupportClassifierConfig.Get();
    }

    const TGeoFeaturesConfig* GetGeoFeaturesConfig() const {
        return GeoFeaturesConfig.Get();
    }

    const TAccountEmailBinderConfig* GetAccountEmailBinderConfig() const {
        return AccountEmailBinderConfig.Get();
    }

    const TSelfHttpRequesterConfig* GetSelfHttpRequester() const {
        return SelfHttpRequesterConfig.Get();
    }

    const TDocumentsManagerConfig* GetDocumentsManagerConfig() const {
        return DocumentsManagerConfig.Get();
    }

    const TTagsManagerConfig* GetTagsManagerConfig() const {
        return TagsManagerConfig.Get();
    }

    const TCovidPassMoscowConfig* GetCovidPassMoscowConfig() const {
        return CovidPassMoscowConfig.Get();
    }

    const TCovidPassMoscowRegionConfig* GetCovidPassMoscowRegionConfig() const {
        return CovidPassMoscowRegionConfig.Get();
    }

    const TCovidPassGosuslugiConfig* GetCovidPassGosuslugiConfig() const {
        return CovidPassGosuslugiConfig.Get();
    }

    const TClckClientConfig* GetClckClientConfig() const {
        return ClckClientConfig.Get();
    }

    const TTaxiChatClientConfig* GetTaxiChatClientConfig() const {
        return TaxiChatClientConfig.Get();
    }

    const TTaxiModuleConfig* GetTaxiRouteInfoClientConfig() const {
        return TaxiRouteInfoClientConfig.Get();
    }

    const TTaxiRouteHistoryConfig* GetTaxiRouteHistoryClientConfig() const {
        return TaxiRouteHistoryClientConfig.Get();
    }

    const TGeobaseConfig* GetGeobaseConfig() const {
        return GeobaseConfig.Get();
    }

    const TBalanceClientConfig* GetBalanceClientConfig() const {
        return BalanceClientConfig.Get();
    }

    const TYaDocClientConfig* GetYaDocClientConfig() const {
        return YaDocClientConfig.Get();
    }

    const IDistributingBlockEventsStorageConfig* GetDistributingBlockEventsStorageConfig() const {
        return DistributingBlockEventsStorageConfig.Get();
    }

    const TTaxiSupportChatSuggestConfig* GetTaxiSupportChatSuggestConfig() const {
        return TaxiSupportChatSuggestConfig.Get();
    }

    const TSendrConfig* GetSendrConfig() const {
        return SendrConfig.Get();
    }

    const TClearWebClientConfig* GetClearWebClientConfig() const {
        return ClearWebClientConfig.Get();
    }

    const TTaxiAntifraudConfig* GetTaxiAntifraudConfig() const {
        return TaxiAntifraudConfig.Get();
    }

    const TTaxiDriverProfilesConfig* GetTaxiDriverProfilesConfig() const {
        return TaxiDriverProfilesConfig.Get();
    }

    const TTaxiDriverStatusConfig* GetTaxiDriverStatusConfig() const {
        return TaxiDriverStatusConfig.Get();
    }

    const TTaxiSignalqDrivematicsApiConfig* GetTaxiSignalqDrivematicsApiConfig() const {
        return TaxiSignalqDrivematicsApiConfig.Get();
    }

    const TTaxiFleetVehiclesConfig* GetTaxiFleetVehiclesConfig() const {
        return TaxiFleetVehiclesConfig.Get();
    }

    const TUserDocumentsCheckConfig* GetUserDocumentsCheckConfig() const {
        return UserDocumentsChecksConfig.Get();
    }

    const TDBEntitiesManagerConfig* GetRadarGeohashConfig() const {
        return RadarGeohashConfig.Get();
    }

    const TTaxiTrackStoryConfig* GetTaxiTrackStoryConfig() const {
        return TaxiTrackStoryConfig.Get();
    }

    const NDrive::TSupportAIApiConfig* GetSupportAIApiConfig() const {
        return SupportAIApiConfig.Get();
    }

    const TYangClientConfig* GetYangClientConfig() const {
        return YangClientConfig.Get();
    }

    const NDrive::NRenins::TReninsConfig* GetReninsApiKaskoConfig() const {
        return ReninsApiKaskoConfig.Get();
    }

    const NDrive::TScootersSurgeConfig* GetScootersSurgeConfig() const;

    const NDrive::TTaxiSurgeCalculatorConfig* GetTaxiSurgeCalculatorConfig() const;
    const NDrive::TSaturnClientConfig* GetSaturnClientConfig() const;
    const TDBEntitiesManagerConfig* GetYDBConfig() const;
    const NDrive::TParkingAggregatorsManagerConfig* GetParkingConfig() const;
    const NDevicesSnapshotManager::TOptions* GetDevicesSnapshotManagerConfig() const;
    const TVector<THttpRewriteConfig>& GetProcessorRewritesConfig() const;
    const NDrive::TTaxiPromocodesClientConfig* GetTaxiPromocodesClientConfig() const;
};

} // namespace NDrive
