#include <drive/backend/server/library/server.h>

#include <drive/backend/server/alloc/alloc.h>
#include <drive/library/cpp/ytprof/ytprof.h>

#include <kernel/daemon/daemon.h>

int main(int argc, char* argv[]) {
    if (GetEnv("TUNE_ALLOC") == "true") {
        NDrive::ConfigureAllocator();
    }

    NYT::NHttp::IServerPtr ytProfServerHolder;
    if (const auto& ytProfPort = FromStringWithDefault<int>(GetEnv("YTPROF_SERVER_PORT"), 0)) {
        ytProfServerHolder = NDrive::CreateYTProfServer(ytProfPort);
        ytProfServerHolder->Start();
    }

    return Singleton<TDaemon<NDrive::TServer> >()->Run(argc, argv);
}
