#include "report.h"

#include <util/generic/map.h>
#include <util/string/cast.h>


NDriveSession::TReportTraits NDriveSession::GetReportTraits(TStringBuf report) {
    TReportTraits reportTraits;
    if (report == "all") {
        reportTraits = NDriveSession::ReportAll;
    } else if (report == "user_app") {
        reportTraits = NDriveSession::ReportUserApp;
    } else if (report == "organization_export") {
        reportTraits = NDriveSession::ReportOrganization;
    } else if (report == "admin_dm") {
        reportTraits = NDriveSession::ReportAdminDM;
    } else {
        reportTraits = NDriveSession::ReportLegacy;
    }
    return reportTraits;
}

NDriveSession::TReportTraits NDriveSession::GetReportTraits(const TMultiMap<TString, TString>& cgi) {
    TString reportTraitsCgi = "default";
    if (auto range = cgi.equal_range("report"); range.first != range.second) {
        reportTraitsCgi = range.first->second;
    }
    if (reportTraitsCgi == "default") {
        TReportTraits reportTraits = NDriveSession::ReportUserApp;
        auto getVal = [&cgi](const TString& key) {
            bool result = false;
            if (auto range = cgi.equal_range(key); range.first != range.second && !TryFromString(range.first->second, result)) {
                return false;
            }
            return result;
        };
        if (!getVal("skip_empty")) {
            reportTraits |= NDriveSession::ReportEmpty;
        }
        if (getVal("fines_info")) {
            reportTraits |= NDriveSession::ReportFines;
        }
        if (getVal("aggressive_info")) {
            reportTraits |= NDriveSession::ReportAggression;
        }
        return reportTraits;
    }
    return GetReportTraits(reportTraitsCgi);
}
