#pragma once

#include <util/generic/string.h>

namespace NDriveSession {
    using TReportTraits = ui32;
    enum EReportTraits : TReportTraits {
        ReportBillSections = 1 << 0,
        ReportOfferShortDescriptionPackDetails = 1 << 1,
        ReportOfferShortDescriptionStandartParkingPrice = 1 << 2,
        ReportSwitchable = 1 << 3,
        ReportOffer = 1 << 4,
        ReportTrack = 1 << 5,
        ReportFavouriteAddressSuggest = 1 << 6,
        ReportPaymentMethods = 1 << 7,
        ReportB2BOrganization = 1 << 8,
        ReportIMEI = 1 << 9,
        ReportPhotos = 1 << 10,
        ReportEmpty = 1 << 11,
        ReportFines = 1 << 12,
        ReportAggression = 1 << 13,
        ReportUserModelInfo = 1 << 14,
        ReportOfferDetails = 1 << 15,
        ReportOfferWallets = 1 << 16,
        ReportStandartOfferPrices = 1 << 17,
        ReportBillSectionsDM = 1 << 18
    };

    constexpr TReportTraits ReportAll = Max<TReportTraits>();
    constexpr TReportTraits ReportUserApp =
        ReportBillSections |
        ReportOfferShortDescriptionPackDetails |
        ReportOfferShortDescriptionStandartParkingPrice |
        ReportPhotos |
        ReportPaymentMethods |
        ReportUserModelInfo |
        ReportOfferDetails |
        ReportOfferWallets |
        ReportStandartOfferPrices;
    constexpr TReportTraits ReportAdminDM =
        ReportUserApp |
        ReportBillSectionsDM;
    constexpr TReportTraits ReportLegacy =
        ReportOfferShortDescriptionPackDetails |
        ReportOfferShortDescriptionStandartParkingPrice |
        ReportPaymentMethods |
        ReportUserModelInfo |
        ReportOfferDetails |
        ReportOfferWallets |
        ReportStandartOfferPrices;
    constexpr TReportTraits ReportOrganization = ReportEmpty;

    TReportTraits GetReportTraits(TStringBuf report);
    TReportTraits GetReportTraits(const TMultiMap<TString, TString>& cgi);
}
