#include "additional_service.h"

#include <drive/backend/data/additional_service.h>
#include <drive/backend/data/additional_service_session.h>
#include <drive/backend/data/offer.h>
#include <drive/backend/logging/evlog.h>

TAdditionalServiceSessionManager::TAdditionalServiceSessionManager(const IDriveTagsManager& driveTagsManager)
    : TBase(driveTagsManager.GetUserTags(), MakeHolder<TAdditionalServiceSessionSelector>(driveTagsManager))
    , DriveTagsManager(driveTagsManager)
{
}

TCommonTagSessionManager::TOptionalConstSessions TAdditionalServiceSessionManager::GetCurrentSessions(NDrive::TEntitySession& tx) const {
    auto optionalTags = DriveTagsManager.GetUserTags().RestoreTagsRobust({}, { TAdditionalServiceOfferHolderTag::Type() }, tx);
    if (!optionalTags) {
        return {};
    }
    TConstSessions result;
    for (auto&& tag : *optionalTags) {
        auto optionalSession = GetTagSession(tag.GetTagId(), tx);
        if (!optionalSession) {
            tx.AddErrorMessage("AdditionalServiceSessionManager::GetCurrentSessions", "cannot GetTagSession for " + tag.GetTagId());
            return {};
        }
        auto session = *optionalSession;
        if (session) {
            result.push_back(std::move(session));
        }
    }
    return result;
}

TCommonTagSessionManager::TOptionalConstSession TAdditionalServiceSessionManager::GetSession(const TString& sessionId, NDrive::TEntitySession& tx) const {
    Y_UNUSED(sessionId);
    Y_UNUSED(tx);
    // TODO
    return {};
}

TAdditionalServiceSessionManager::TOptionalConstSessions TAdditionalServiceSessionManager::GetUserSessions(const TString& userId, NDrive::TEntitySession& tx, TDuration finishedDepth) const {
    Y_UNUSED(finishedDepth);

    TConstSessions result;
    const auto& userTagManager = DriveTagsManager.GetUserTags();
    auto optionalTaggedUser = userTagManager.RestoreObject(userId, tx);
    if (!optionalTaggedUser) {
        return {};
    }
    for (auto&& tag : optionalTaggedUser->GetTags()) {
        auto offerHolder = tag.GetTagAs<TAdditionalServiceOfferHolderTag>();
        if (!offerHolder) {
            continue;
        }
        auto offerHolderSession = GetTagSession(tag.GetTagId(), tx);;
        if (!offerHolderSession) {
            continue;
        }
        result.push_back(std::move(*offerHolderSession));
    }

    return result;
}
