#pragma once

#include "common.h"

#include <drive/library/cpp/threading/concurrent_cache.h>

class TAdditionalServiceSessionManager: public TCommonTagSessionManager {
private:
    using TBase = TCommonTagSessionManager;

public:
    TAdditionalServiceSessionManager(const IDriveTagsManager& driveTagsManager);

    TOptionalConstSessions GetCurrentSessions(NDrive::TEntitySession& tx) const;

    virtual TOptionalConstSession GetSession(const TString& id, NDrive::TEntitySession& tx) const;
    virtual TOptionalConstSessions GetUserSessions(const TString& userId, NDrive::TEntitySession& tx, TDuration finishedDepth = TDuration::Zero()) const override;

private:
    const IDriveTagsManager& DriveTagsManager;
};
