#pragma once

#include "common.h"

#include <drive/library/cpp/threading/concurrent_cache.h>

class TSessionManager: public TCommonTagSessionManager {
private:
    using TBase = TCommonTagSessionManager;

    struct TSessionTagInfo {
        TString TagId;
        NEntityTagsManager::EEntityType TagEntityType = NEntityTagsManager::EEntityType::Car;
        TInstant Timestamp;
    };
    using TSessionTagInfos = TMap<TString, TSessionTagInfo>;
    using TOptionalSessionTagInfos = TMaybe<TSessionTagInfos>;

public:
    TSessionManager(const IDriveTagsManager& driveTagsManager);

    TOptionalSessionTagInfos GetCurrentSessions(NDrive::TEntitySession& tx) const;

    virtual TOptionalConstSession GetSession(const TString& id, NDrive::TEntitySession& tx) const;
    virtual TOptionalConstSessions GetObjectSessions(const TString& objectId, NDrive::TEntitySession& tx) const;
    virtual TOptionalConstSessions GetObjectsSessions(const TVector<TString>& objectsIds, NDrive::TEntitySession& tx) const;
    virtual TOptionalConstSessions GetUserSessions(const TString& userId, NDrive::TEntitySession& tx, TDuration finishedDepth = TDuration::Zero()) const override;

private:
    const IDriveTagsManager& DriveTagsManager;
    const TDuration DefaultCacheLifetime;

    mutable NUtil::TConcurrentCache<TString, TSessionTagInfo> SessionTagInfoCache;
};
