#pragma once

#include <drive/backend/database/history/session.h>
#include <drive/backend/tags/tags_manager.h>

#include <drive/library/cpp/threading/concurrent_cache.h>

class TCommonTagSessionManager {
public:
    using TSession = IEventsSession<TTagHistoryEvent>;
    using TSessionPtr = TAtomicSharedPtr<TSession>;
    using TSessionConstPtr = TAtomicSharedPtr<const TSession>;
    using TSessionSelector = ISessionSelector<TTagHistoryEvent>;

    using TSessions = TVector<TSessionPtr>;
    using TConstSessions = TVector<TSessionConstPtr>;
    using TOptionalConstSession = TMaybe<TSessionConstPtr>;
    using TOptionalConstSessions = TMaybe<TConstSessions>;

public:
    TCommonTagSessionManager(const IEntityTagsManager& tagManager, THolder<TSessionSelector>&& selector)
        : TagManager(tagManager)
        , Selector(std::move(selector))
        , TagIdIndex(256 * 1024)
    {
    }

    virtual ~TCommonTagSessionManager() = default;

    virtual TOptionalConstSession GetTagSession(const TString& tagId, NDrive::TEntitySession& tx) const;
    virtual TOptionalConstSessions GetUserSessions(const TString& userId, NDrive::TEntitySession& tx, TDuration finishedDepth = TDuration::Zero()) const;
    virtual TOptionalConstSessions GetSessionsActualSinceId(TRange<TTagHistoryEvent::TEventId> idRange, NDrive::TEntitySession& tx) const;
    virtual TOptionalConstSessions GetObjectSessionsByTagNames(const TString& objectId, const TVector<TString>& tagNames, NDrive::TEntitySession& tx, TDuration finishedDepth = TDuration::Zero()) const;

    TSessionPtr ConsumeEvents(THolder<TSession>&& consumer, TTagHistoryEvents&& events, bool updateCache = false) const;

protected:
    const IEntityTagsManager& GetTagManager() const {
        return TagManager;
    }

protected:
    const IEntityTagsManager& TagManager;
    THolder<TSessionSelector> Selector;

    mutable NUtil::TConcurrentCache<TString, TSessionPtr> TagIdIndex;
};
