#pragma once

#include "common.h"

#include <drive/library/cpp/threading/concurrent_cache.h>

class TDedicatedFleetSessionManager : public TCommonTagSessionManager {
private:
    using TBase = TCommonTagSessionManager;

private:
    class TUnitSessionManager : public TCommonTagSessionManager {
    private:
        using TBase = TCommonTagSessionManager;

    public:
        TUnitSessionManager(const IDriveTagsManager& driveTagsManager);
    };

public:
    TDedicatedFleetSessionManager(const IDriveTagsManager& driveTagsManager);

    TOptionalConstSessions GetAccountCurrentSessions(const TString& accountId, NDrive::TEntitySession& tx) const;
    TOptionalConstSessions GetAccountSessions(const TString& accountId, NDrive::TEntitySession& tx) const;
    TOptionalConstSession GetTagSession(const TString& tagId, NDrive::TEntitySession& tx) const override;
    TSessionPtr ConsumeEvents(THolder<TSession>&& consumer, TTagHistoryEvents&& events, bool updateCache) const;

protected:
    const IEntityTagsManager& CarTagsManager;
};
