#include "config.h"

void TSettingsConfig::Init(const TYandexConfig::Section* section) {
    const auto& directives = section->GetDirectives();
    Prefix = directives.Value("Prefix", Prefix);
    DBName = directives.Value("DBName", DBName);
    PrefixNewBehaviour = directives.Value("PrefixNewBehaviour", PrefixNewBehaviour);
    AssertCorrectConfig(!!DBName, "Incorrect DBName for settings");
    HistoryConfig.Init(section);
    auto allChildren = section->GetAllChildren();
    if (auto it = allChildren.find("Propositions"); it != allChildren.end()) {
        PropositionsConfig.Init(it->second);
    }
}

void TSettingsConfig::ToString(IOutputStream& os) const {
    os << "DBName: " << DBName << Endl;
    os << "Prefix: " << Prefix << Endl;
    os << "PrefixNewBehaviour: " << PrefixNewBehaviour << Endl;
    HistoryConfig.ToString(os);
    os << "<Propositions>" << Endl;
    PropositionsConfig.ToString(os);
    os << "</Propositions>" << Endl;
}
