#pragma once

#include "config.h"

#include <drive/backend/abstract/base.h>
#include <drive/backend/database/history/manager.h>

class TSettingConditionConstructor {
public:
    static TString BuildCondition(const TSet<TString>& ids, NDrive::TEntitySession& session);
    static NStorage::TTableRecord BuildCondition(const TString& id);
    template <class T>
    static NStorage::TTableRecord BuildCondition(const T& object);
};

class TSettingsPropositions: public TPropositionsManager<TSetting> {
private:
    using TBase = TPropositionsManager<TSetting>;

public:
    TSettingsPropositions(const IHistoryContext& context, const TPropositionsManagerConfig& config)
        : TBase(context, TSetting::GetPropositionsTableName(), config)
    {
    }
};

class TSettingsDB
    : public TDBEntitiesManager<TSetting, TSettingConditionConstructor>
    , public IDBEntitiesWithPropositionsManager<TSetting>
    , public ISettings {
private:
    using TBase = TDBEntitiesManager<TSetting, TSettingConditionConstructor>;

private:
    TString Prefix;
    bool PrefixNewBehaviour;
    TSettingsPropositions Propositions;

private:
    virtual TStringBuf GetEventObjectId(const TObjectEvent<TSetting>& ev) const override {
        return ev.GetKey();
    }

    template <class T>
    bool GetValueImpl(TStringBuf key, T& result, TInstant reqActuality) const;
    bool GetValueOld(TStringBuf key, TString& result, TInstant reqActuality) const;
    bool GetValueNew(TStringBuf key, TString& result, TInstant reqActuality) const;

public:
    TSettingsDB(const IHistoryContext& context, const TSettingsConfig& config);
    ~TSettingsDB();

    virtual bool GetAllSettings(TVector<TSetting>& result, const TInstant reqActuality) const override;
    virtual bool RemoveKeys(const TVector<TString>& keys, const TString& userId) const override;
    virtual bool SetValues(const TVector<TSetting>& values, const TString& userId) const override;
    virtual bool GetHistory(const TInstant since, TVector<TAtomicSharedPtr<TObjectEvent<TSetting>>>& result, const TInstant reqActuality) const override;
    virtual bool HasValues(const TSet<TString>& keys, TSet<TString>& existKeys, const TInstant reqActuality) const override;
    virtual bool GetValueStr(TStringBuf key, TString& result, TInstant reqActuality) const override;

    bool SetValueWithRevision(const TSetting& values, const TString& userId, NDrive::TEntitySession& session) const;

    const TPropositionsManager<TSetting>* GetPropositions() const override {
        return &Propositions;
    }
};
