#pragma once

#include "tag.h"

#include <drive/backend/database/transaction/tx.h>
#include <drive/backend/report/json.h>
#include <drive/backend/roles/permissions.h>
#include <drive/backend/tags/tags.h>
#include <drive/backend/tags/tags_manager.h>

#include <rtline/util/types/field.h>

#include <util/datetime/base.h>
#include <util/generic/map.h>
#include <util/generic/set.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/system/types.h>

inline static TString SignalqSignalsDescriptionSettingName = "signalq.signalq_events.signals_description";

namespace NDrivematics {
    class TSignalDescription;
}

namespace NDrive {
    inline const ui64 DefaultMaxQueriesCount = 1;
    inline const ui64 DefaultLimitPerQuery = 50;

    class TTraceSignalsQuerySettings {
    public:
        R_FIELD(ui64, MaxQueriesCount, DefaultMaxQueriesCount);
        R_FIELD(ui64, LimitPerQuery, DefaultLimitPerQuery);

    public:
        DECLARE_FIELDS(
            Field(MaxQueriesCount, "max_queries_count"),
            Field(LimitPerQuery, "limit_per_query")
        );
    };

    class TTraceSignalsQueryParams {
        R_OPTIONAL(TString, SignalId);
        R_OPTIONAL(ui64, PageSize);
        R_OPTIONAL(ui64, SessionTagHistoryCursor);
        R_FIELD(TSet<TString>, ReportedSignalsNames);
        R_FIELD(TSet<TString>, SignalqSignalsNames);
        R_FIELD(TVector<TString>, VisibleSessionIds);
        R_FIELD(TRange<TInstant>, PeriodRange);
        R_FIELD(ui64, MaxQueriesCount, DefaultMaxQueriesCount);
        R_FIELD(ui64, LimitPerQuery, DefaultLimitPerQuery);
        R_FIELD(bool, SupportMode, false);
    };

    class TTraceSignalsResultData {
        R_FIELD(TTagHistoryEvents, TraceSignals);
        R_OPTIONAL(ui64, LastEventsCursor);;
    };

    TTraceSignalsResultData GetTraceSignals(
        TJsonReport::TGuard& g,
        NDrive::TEntitySession& tx,
        const TTraceTagsManager& traceTagsManager,
        TTraceSignalsQueryParams&& params);

namespace NSignalq {
    TString GetDeletedTagName();
    TString GetSupportPreapprovedTagName();
    TMap<TString, TString> GetEventToTagName();
    TVector<NDrivematics::TSignalDescription> GetSignalDescriptions();

    void ProcessTagResolution(
            TDBTag& tag,
            const NDrive::NSignalq::EEventResolution resolution,
            const NDrive::IServer* server,
            const TUserPermissions::TPtr& permissions,
            NDrive::TEntitySession& tx
    );
} // namespace NSignalq

} // namespace NDrive
