#pragma once

#include <drive/backend/drivematics/signal/tag.h>
#include <drive/library/cpp/taxi/signalq_drivematics_api/definitions.h>

class TSignalqEventTraceTag : public NDrivematics::TCommonSignalTag {
public:
    class TDescription: public TTagDescription {
    private:
        using TBase = TTagDescription;

    public:
        using TBase::TBase;
        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        static TFactory::TRegistrator<TDescription> Registrator;
    };

private:
    using TBase = NDrivematics::TCommonSignalTag;

public:
    R_FIELD(NDrive::NSignalq::TEvent, Event);
    R_FIELD(TString, SerialNumber);

private:
    static TFactory::TRegistrator<TSignalqEventTraceTag> Registrator;

public:
    using TBase::TBase;

    static inline const TString TypeName{"signalq_event_trace_tag"};

public:
    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    NJson::TJsonValue GetDetailReport() const override;
    NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    TString GetSignalNameOverride() const override;

    TString MakeSerialNumberEventId() const;

    bool OnBeforeAdd(const TString& entityId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) override;
    bool OnBeforeUpdate(const TDBTag& self, ITag::TPtr to, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) const override;

protected:
    NEntityTagsManager::EEntityType GetEntityType() const override {
        return NEntityTagsManager::EEntityType::Trace;
    }

    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;
};
