#include "entities.h"


TAudioteleCallEvent::TDecoder::TDecoder(const TMap<TString, ui32>& decoderBase) {
    Id = GetFieldDecodeIndex("id", decoderBase);
    EnterTS = GetFieldDecodeIndex("time_enter", decoderBase);
    ConnectTS = GetFieldDecodeIndex("time_connect", decoderBase);
    ExitTS = GetFieldDecodeIndex("time_exit", decoderBase);
    Answered = GetFieldDecodeIndex("is_answered", decoderBase);
    Duration = GetFieldDecodeIndex("duration", decoderBase);
    Phone = GetFieldDecodeIndex("phone", decoderBase);
    Agent = GetFieldDecodeIndex("agent", decoderBase);
    UserId = GetFieldDecodeIndex("user_binding_id", decoderBase);
    CallCenterStaffId = GetFieldDecodeIndex("staff_entry_binding_id", decoderBase);
    Direction = GetFieldDecodeIndex("direction", decoderBase);
    ExternalCallId = GetFieldDecodeIndex("related_call_id", decoderBase);
    Meta = GetFieldDecodeIndex("meta_info", decoderBase);
    Action = GetFieldDecodeIndex("action", decoderBase);
}

bool TAudioteleCallEvent::DeserializeWithDecoder(const TAudioteleCallEvent::TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
    READ_DECODER_VALUE(decoder, values, Id);
    READ_DECODER_VALUE_INSTANT_ISOFORMAT_OPT(decoder, values, EnterTS);
    if (!EnterTS) {
        return false;
    }
    READ_DECODER_VALUE_INSTANT_ISOFORMAT_OPT(decoder, values, ConnectTS);
    READ_DECODER_VALUE_INSTANT_ISOFORMAT_OPT(decoder, values, ExitTS);
    READ_DECODER_VALUE(decoder, values, Answered);
    READ_DECODER_VALUE_DEF(decoder, values, Duration, Duration);
    READ_DECODER_VALUE_DEF(decoder, values, Phone, Phone);
    READ_DECODER_VALUE_DEF(decoder, values, Agent, Agent);
    READ_DECODER_VALUE_DEF(decoder, values, UserId, UserId);
    READ_DECODER_VALUE_DEF(decoder, values, CallCenterStaffId, CallCenterStaffId);
    READ_DECODER_VALUE(decoder, values, Direction);
    READ_DECODER_VALUE(decoder, values, ExternalCallId);
    {
        TString metaInfo;
        READ_DECODER_VALUE_TEMP_OPT(decoder, values, metaInfo, Meta);
        if (metaInfo && !NJson::ReadJsonTree(metaInfo, &Meta)) {
            return false;
        }
    }
    READ_DECODER_VALUE(decoder, values, Action);
    return true;
}

bool TAudioteleCallEvent::Parse(const NStorage::TTableRecord& row) {
    return TBaseDecoder::DeserializeFromTableRecord(*this, row);
}


TAudioteleCallTrack::TDecoder::TDecoder(const TMap<TString, ui32>& decoderBase) {
    Id = GetFieldDecodeIndex("id", decoderBase);
    FileName = GetFieldDecodeIndex("file_name", decoderBase);
    FileAttrs = GetFieldDecodeIndex("file_attrs", decoderBase);
    CallEventId = GetFieldDecodeIndex("call_entry_id", decoderBase);
}

NStorage::TTableRecord TAudioteleCallTrack::SerializeToTableRecord() const {
    NStorage::TTableRecord result;
    result.Set("id", Id);
    result.Set("file_name", FileName);
    if (FileAttrs.IsDefined()) {
        result.Set("file_attrs", FileAttrs.GetStringRobust());
    } else {
        result.Set("file_attrs", "get_null()");
    }
    if (CallEventId) {
        result.Set("call_entry_id", CallEventId);
    } else {
        result.Set("call_entry_id", "get_null()");
    }
    return result;
}

bool TAudioteleCallTrack::DeserializeWithDecoder(const TAudioteleCallTrack::TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
    READ_DECODER_VALUE(decoder, values, Id);
    READ_DECODER_VALUE(decoder, values, FileName);
    {
        TString metaInfo;
        READ_DECODER_VALUE_TEMP_OPT(decoder, values, metaInfo, FileAttrs);
        if (metaInfo && !NJson::ReadJsonTree(metaInfo, &FileAttrs)) {
            return false;
        }
    }
    READ_DECODER_VALUE_DEF(decoder, values, CallEventId, CallEventId);
    return true;
}

bool TAudioteleCallTrack::Parse(const NStorage::TTableRecord& row) {
    return TBaseDecoder::DeserializeFromTableRecord(*this, row);
}

TString TAudioteleCallTrack::GetMdsKey() const{
    return GetId() + "/" +  GetFileName();
}
