#pragma once

#include <rtline/library/storage/structured.h>
#include <rtline/util/types/accessor.h>


class TAudioteleCallEvent {
public:
    enum class EDirection {
        Incoming = 0 /* "i" */,
        Outcoming = 1 /* "o" */,
    };

    enum class EAction {
        Start = 0 /* "start" */,
        Finish = 1 /* "finish" */,
    };

private:
    R_READONLY(ui64, Id, 0);
    R_FIELD(TInstant, EnterTS, TInstant::Zero());
    R_FIELD(TInstant, ConnectTS, TInstant::Zero());
    R_FIELD(TInstant, ExitTS, TInstant::Zero());
    R_FIELD(TDuration, Duration, TDuration::Zero());
    R_FIELD(bool, Answered, false);
    R_FIELD(TString, Phone);
    R_FIELD(TString, Agent);
    R_FIELD(TString, UserId);
    R_FIELD(ui64, CallCenterStaffId, 0);
    R_FIELD(EDirection, Direction);
    R_FIELD(TString, ExternalCallId);
    R_FIELD(NJson::TJsonValue, Meta);
    R_FIELD(EAction, Action);

public:
    using TId = ui64;
    class TDecoder : public TBaseDecoder {
        R_FIELD(ui32, Id, -1);
        R_FIELD(ui32, EnterTS, -1);
        R_FIELD(ui32, ConnectTS, -1);
        R_FIELD(ui32, ExitTS, -1);
        R_FIELD(ui32, Answered, -1);
        R_FIELD(ui32, Duration, -1);
        R_FIELD(ui32, Phone, -1);
        R_FIELD(ui32, Agent, -1);
        R_FIELD(ui32, UserId, -1);
        R_FIELD(ui32, CallCenterStaffId, -1);
        R_FIELD(ui32, Direction, -1);
        R_FIELD(ui32, ExternalCallId, -1);
        R_FIELD(ui32, Meta, -1);
        R_FIELD(ui32, Action, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase);
    };

    TId GetInternalId() const {
        return Id;
    }

    static TString GetTableName() {
        return "audiotele_call_stats";
    }

    bool operator!() const {
        return false;
    }

    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);
    bool Parse(const NStorage::TTableRecord& row);
};

class TAudioteleCallTrack {
    R_READONLY(TString, Id);
    R_FIELD(TString, FileName);
    R_FIELD(NJson::TJsonValue, FileAttrs);
    R_FIELD(TAudioteleCallEvent::TId, CallEventId, 0);

public:
    using TId = TString;
    class TDecoder : public TBaseDecoder {
        R_FIELD(ui32, Id, -1);
        R_FIELD(ui32, FileName, -1);
        R_FIELD(ui32, FileAttrs, -1);
        R_FIELD(ui32, CallEventId, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase);
    };

    TId GetInternalId() const {
        return Id;
    }

    static TString GetTableName() {
        return "audiotele_call_tracks";
    }

    bool operator!() const {
        return false;
    }

    NStorage::TTableRecord SerializeToTableRecord() const;
    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);
    bool Parse(const NStorage::TTableRecord& row);
    TString GetMdsKey() const;
};
