#pragma once

#include "entities.h"

#include <drive/backend/database/entity/manager.h>

class TAudioteleCallsManager: public TDatabaseSessionConstructor {
public:
    class TAudioteleCallEventsManager : public TDatabaseEntityManager<TAudioteleCallEvent, /* OneToOne = */ true, /* TKey = */ TAudioteleCallEvent::TId> {
        using TBase = TDatabaseEntityManager<TAudioteleCallEvent, /* OneToOne = */ true, /* TKey = */ TAudioteleCallEvent::TId>;

    public:
        TAudioteleCallEventsManager(NStorage::IDatabase::TPtr database);
        virtual TString GetTableName() const override;
        TAudioteleCallEvent::TId GetMainId(const TAudioteleCallEvent& e) const override;
        TMaybe<TVector<TAudioteleCallEvent>> GetObjects(NDrive::TEntitySession& session, const TSet<TAudioteleCallEvent::EAction>& filterActions, const TSet<TString>& callIds, const ui32 limit) const;
    };

    class TAudioteleCallTrackManager : public TDatabaseEntityManager<TAudioteleCallTrack, /* OneToOne = */ true, /* TKey = */ TAudioteleCallTrack::TId> {
        using TBase = TDatabaseEntityManager<TAudioteleCallTrack, /* OneToOne = */ true, /* TKey = */ TAudioteleCallTrack::TId>;

    public:
        TAudioteleCallTrackManager(NStorage::IDatabase::TPtr database);
        virtual TString GetTableName() const override;
        TAudioteleCallTrack::TId GetMainId(const TAudioteleCallTrack& e) const override;
    };

public:
    TAudioteleCallsManager(NStorage::IDatabase::TPtr database);

    TMaybe<TVector<TAudioteleCallEvent>> GetEvents(NDrive::TEntitySession& session, const TSet<TAudioteleCallEvent::EAction>& filterActions, const TSet<TString>& callIds, const ui32 limit = 0) const;
    TMaybe<TVector<TAudioteleCallTrack>> GetTracksByEvents(NDrive::TEntitySession& session, const TSet<TAudioteleCallEvent::TId>& eventIds) const;
    TMaybe<TVector<TAudioteleCallTrack>> GetTracksByCallId(NDrive::TEntitySession& session, const TString& callId) const;
    TMaybe<TMap<TString, TString>> GetCallTracksKeys(NDrive::TEntitySession& session, const TSet<TString>& callIds, const ui32 limit = 0) const;
    bool BindCallTrack(const TAudioteleCallEvent::TId eventId, const TAudioteleCallTrack::TId& trackd, NDrive::TEntitySession& session) const;

private:
    TAudioteleCallEventsManager EventManager;
    TAudioteleCallTrackManager TrackManager;
};
