#include "entities.h"

#include <rtline/library/json/parse.h>

TPhoneCall::TDecoder::TDecoder(const TMap<TString, ui32>& decoderBase) {
    Id = GetFieldDecodeIndex("id", decoderBase);
    Status = GetFieldDecodeIndex("status", decoderBase);
    PerformerId = GetFieldDecodeIndex("performer_id", decoderBase);
    UserId = GetFieldDecodeIndex("user_id", decoderBase);
    ExternalId = GetFieldDecodeIndex("external_id", decoderBase);
    StartTS = GetFieldDecodeIndex("start_ts", decoderBase);
    EndTS = GetFieldDecodeIndex("end_ts", decoderBase);
    AnswerTS = GetFieldDecodeIndex("answer_ts", decoderBase);
    TagId = GetFieldDecodeIndex("tag_id", decoderBase);
    Phone = GetFieldDecodeIndex("phone", decoderBase);
    Comment = GetFieldDecodeIndex("comment", decoderBase);
    Meta = GetFieldDecodeIndex("meta", decoderBase);
}

NStorage::TTableRecord TPhoneCall::SerializeToTableRecord() const {
    NStorage::TTableRecord result;
    if (Id) {
        result.Set("id", Id);
    }
    result.Set("status", ToString(Status));
    result.Set("user_id", UserId);
    result.Set("start_ts", StartTS);
    result.Set("end_ts", EndTS);
    result.Set("answer_ts", AnswerTS);

    result.SetNonNull("phone", Phone);
    result.SetNonNull("comment", Comment);
    result.SetNonNull("external_id", ExternalId);

    if (Meta.IsDefined()) {
        result.Set("meta", Meta);
    }
    return result;
}

NJson::TJsonValue TPhoneCall::SerializeToJsonReport() const {
    NJson::TJsonValue json;
    json.InsertValue("id", Id);
    json.InsertValue("status", ToString(Status));
    json.InsertValue("user_id", UserId);
    NJson::InsertNonNull(json, "external_id", ExternalId);
    NJson::InsertNonNull(json, "phone", Phone);
    NJson::InsertNonNull(json, "comment", Comment);
    NJson::InsertNonNull(json, "start_ts", StartTS);
    NJson::InsertNonNull(json, "end_ts", EndTS);
    NJson::InsertNonNull(json, "answer_ts", AnswerTS);
    if (StartTS && EndTS) {
        NJson::InsertNonNull(json, "duration", StartTS.Seconds() - EndTS.Seconds());
    }
    json.InsertValue("meta", Meta);
    return json;
}

bool TPhoneCall::DeserializePhoneWithDecoder(const TPhoneCall::TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
    READ_DECODER_VALUE(decoder, values, Id);
    READ_DECODER_VALUE(decoder, values, Status);
    READ_DECODER_VALUE(decoder, values, UserId);

    READ_DECODER_VALUE_TEMP_OPT(decoder, values, Phone, Phone);
    READ_DECODER_VALUE_TEMP_OPT(decoder, values, Comment, Comment);
    READ_DECODER_VALUE_TEMP_OPT(decoder, values, ExternalId, ExternalId);

    READ_DECODER_VALUE_INSTANT(decoder, values, StartTS);
    READ_DECODER_VALUE_INSTANT(decoder, values, EndTS);
    READ_DECODER_VALUE_INSTANT(decoder, values, AnswerTS);

    READ_DECODER_VALUE_JSON(decoder, values, Meta, Meta);
    return true;
}
