#pragma once

#include <rtline/library/storage/structured.h>
#include <rtline/util/types/accessor.h>


class TPhoneCall {
public:
    enum class EStatus {
        Initialized = 0 /* "initialized" */,
        Servised = 1 /* "servised" */,
        NotServised = 2 /* "not_servised" */,
        Completed = 3 /* "completed" */,
    };

    using TId = ui64;

    class TDecoder : public TBaseDecoder {
        R_FIELD(i32, Id, -1);
        R_FIELD(i32, Status, -1);
        R_FIELD(i32, PerformerId, -1);
        R_FIELD(i32, UserId, -1);
        R_FIELD(i32, ExternalId, -1);
        R_FIELD(i32, StartTS, -1);
        R_FIELD(i32, EndTS, -1);
        R_FIELD(i32, AnswerTS, -1);
        R_FIELD(i32, TagId, -1);
        R_FIELD(i32, Phone, -1);
        R_FIELD(i32, Comment, -1);
        R_FIELD(i32, Meta, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase);
    };

private:
    R_FIELD(ui64, Id, 0);
    R_FIELD(EStatus, Status, EStatus::Initialized);
    R_FIELD(TString, UserId);

    R_FIELD(TString, ExternalId);
    R_FIELD(TInstant, StartTS, TInstant::Zero());
    R_FIELD(TInstant, EndTS, TInstant::Zero());
    R_FIELD(TInstant, AnswerTS, TInstant::Zero());

    R_FIELD(TString, Phone);
    R_FIELD(TString, Comment);
    R_FIELD(NJson::TJsonValue, Meta);

public:
    TPhoneCall() = default;
    virtual ~TPhoneCall() = default;

    TId GetInternalId() const {
        return Id;
    }

    explicit operator bool() const {
        return true;
    }

    virtual NStorage::TTableRecord SerializeToTableRecord() const;
    virtual NJson::TJsonValue SerializeToJsonReport() const;
    virtual bool DeserializePhoneWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext);
    virtual bool DeserializeFromJson(const NJson::TJsonValue& data) = 0;
};
