#include "config.h"

void TSupportCenterManagerConfig::Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy) {
    const auto& directives = section->GetDirectives();
    DBName = directives.Value("DBName", DBName);
    SupportAIDBName = directives.Value("SupportAIDBName", DBName);
    AudioteleDBName = directives.Value("AudioteleDBName", DBName);
    InternalCallCenterDBName = directives.Value("InternalCallCenterDBName", DBName);
    auto children = section->GetAllChildren();
    {
        auto it = children.find("Categorizer");
        if (it != children.end()) {
            CategorizerConfig.Init(it->second);
        }
    }
    {
        auto it = children.find("WebphoneClient");
        if (it != children.end()) {
            WebphoneClientConfig.Init(it->second);
        }
    }
    {
        auto it = children.find("CallCenterYandexClient");
        if (it != children.end()) {
            CallCenterYandexConfig.ConstructInPlace();
            CallCenterYandexConfig->Init(it->second, requestPolicy);
        }
    }
    {
        auto it = children.find("InternalCallCenterClient");
        if (it != children.end()) {
            InternalCallCenterConfig.Init(it->second);
        }
    }
    {
        auto mdsIt = children.find("MDS");
        if (mdsIt != children.end()) {
            MDSClientConfig.ConstructInPlace();
            MDSClientConfig->Init(mdsIt->second, requestPolicy);
        }
    }
}

void TSupportCenterManagerConfig::ToString(IOutputStream& os) const {
    os << "DBName: " << DBName << Endl;
    os << "SupportAIDBName: " << SupportAIDBName << Endl;
    os << "AudioteleDBName: " << AudioteleDBName << Endl;

    os << "<Categorizer>" << Endl;
    CategorizerConfig.ToString(os);
    os << "</Categorizer>" << Endl;

    os << "<WebphoneClient>" << Endl;
    WebphoneClientConfig.ToString(os);
    os << "</WebphoneClient>" << Endl;

    if (CallCenterYandexConfig.Defined()) {
        os << "<CallCenterYandexClient>" << Endl;
        CallCenterYandexConfig->ToString(os);
        os << "</CallCenterYandexClient>" << Endl;
    }

    os << "InternalCallCenterDBName: " << InternalCallCenterDBName << Endl;
    os << "<InternalCallCenterClient>" << Endl;
    InternalCallCenterConfig.ToString(os);
    os << "</InternalCallCenterClient>" << Endl;

    if (MDSClientConfig.Defined()) {
        os << "<MDS>" << Endl;
        MDSClientConfig->ToString(os);
        os << "</MDS>" << Endl;
    }
}
