#pragma once

#include <drive/backend/support_center/categorizer/model.h>
#include <drive/backend/support_center/yandex/config.h>

#include <drive/library/cpp/mds/config.h>
#include <drive/library/cpp/webphone/config.h>

class TSupportCenterManagerConfig {
    R_FIELD(TString, DBName);
    R_FIELD(TSupportRequestCategorizerConfig, CategorizerConfig);
    R_FIELD(TWebphoneClientConfig, WebphoneClientConfig);
    R_OPTIONAL(NCallCenterYandex::TCallCenterYandexClientConfig, CallCenterYandexConfig);
    R_FIELD(TString, SupportAIDBName);
    R_FIELD(TString, AudioteleDBName);
    R_FIELD(TString, InternalCallCenterDBName);
    R_FIELD(NCallCenterYandex::TInternalCallCenterConfig, InternalCallCenterConfig);
    R_OPTIONAL(TS3ClientConfig, MDSClientConfig);

public:
    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;
};
