#include "chat.h"

#include <rtline/util/json_processing.h>

NJson::TJsonValue TSupportChatFeedback::SerializeToJson() const {
    NJson::TJsonValue result;
    result["overall_quality"] = OverallQuality;
    {
        NJson::TJsonValue issuesArray = NJson::JSON_ARRAY;
        for (auto&& issue : Issues) {
            NJson::TJsonValue issueDesc;
            issueDesc["issue"] = issue;
            issuesArray.AppendValue(std::move(issueDesc));
        }
        result["issues"] = std::move(issuesArray);
    }
    return result;
}

bool TSupportChatFeedback::DeserializeFromJson(const NJson::TJsonValue& raw) {
    if (!raw.IsMap()) {
        return false;
    }

    OverallQuality = "";
    JREAD_STRING_OPT(raw, "overall_quality", OverallQuality);
    if (!raw["issues"].IsArray()) {
        return false;
    }

    Issues.clear();
    for (auto&& issueJson : raw["issues"].GetArray()) {
        if (!issueJson.Has("issue") || !issueJson["issue"].IsString()) {
            return false;
        }
        Issues.push_back(issueJson["issue"].GetString());
    }
    return true;
}

void TSupportChatFeedback::SerializeToProto(TSupportChatFeedback::TProto* proto) const {
    proto->SetOverallQuality(OverallQuality);
    for (auto&& issueStr : Issues) {
        NDrive::NProto::TSupportFeedbackData::TIssue* issue = proto->AddIssues();
        issue->SetName(issueStr);
    }
}

void TSupportChatFeedback::DeserializeFromProto(const TSupportChatFeedback::TProto& proto) {
    OverallQuality = proto.GetOverallQuality();
    Issues.clear();
    for (auto issue : proto.GetIssues()) {
        Issues.push_back(issue.GetName());
    }
}
