#pragma once

#include <drive/backend/support_center/feedback/proto/feedback.pb.h>

#include <library/cpp/json/writer/json_value.h>

#include <rtline/util/types/accessor.h>


class TSupportChatFeedback {
    R_FIELD(TString, OverallQuality);
    R_FIELD(TVector<TString>, Issues);

private:
    using TProto = NDrive::NProto::TSupportFeedbackData;

public:
    NJson::TJsonValue SerializeToJson() const;
    bool DeserializeFromJson(const NJson::TJsonValue& raw);
    void SerializeToProto(TSupportChatFeedback::TProto* proto) const;
    void DeserializeFromProto(const TProto& proto);
};
