#pragma once

#include <drive/library/cpp/threading/future.h>

#include <rtline/util/types/messages_collector.h>

#include <util/generic/string.h>
#include <util/generic/maybe.h>

class TAudioteleCallsManager;
class TSupportRequestCategorizationDB;
class TSupportRequestsDistributonManager;
class TWebphoneClient;
class TWebPhoneCallManager;
class TCiptCallEventsReader;
class TSupportAICallManager;
class TS3Client;

namespace NS3 {
    class TBucket;
}


class TLoadBalanceCalendarHelper;
class TLegacyPriorityManager;

namespace NCallCenterYandex {
    class TCallCenterYandexClient;
    class TAppDistribution;
    class TInternalCallCenterClient;

    enum class EInternalCallProcessResult;
}

namespace NDrive {
    class TEntitySession;
}

class ISupportCenterManager {
protected:
    class TS3Bucket;

public:
    static const TString LoadBalanceSettingKey;
    static const TString IVRSettingKey;

public:
    virtual ~ISupportCenterManager() = default;

    virtual void Start() = 0;
    virtual void Stop() = 0;

    virtual NDrive::TEntitySession BuildSession(const bool readOnly = false) const = 0;

    virtual TSupportRequestCategorizationDB* GetSupportRequestCategorizer() const = 0;
    virtual TLegacyPriorityManager* GetLegacyPriorityManager() const = 0;
    virtual TWebphoneClient* GetWebphoneClient() const = 0;
    virtual NCallCenterYandex::TCallCenterYandexClient* GetCallCenterYandexClient() const = 0;
    virtual const NCallCenterYandex::TInternalCallCenterClient& GetInternalCallCenterClient() const = 0;
    virtual const TAudioteleCallsManager& GetAudioteleCallsManager() const = 0;
    virtual const TWebPhoneCallManager& GetWebPhoneCallManager() const = 0;
    virtual const TCiptCallEventsReader& GetCiptCallEventsReader() const = 0;
    virtual const TSupportAICallManager& GetSupportAICallManager() const = 0;
    virtual TS3Client* GetMDSClient() const = 0;

    virtual TMaybe<TLoadBalanceCalendarHelper> GetLoadBalanceCalendar(const TString& appName) const = 0;
    virtual bool UpdateLoadBalanceCalendar(const TLoadBalanceCalendarHelper& calendar, const TString& performerId) const = 0;

    virtual TMaybe<NCallCenterYandex::TAppDistribution> GetCurrentLoadBalanceCalendarValue(const TString& appName) const = 0;
    virtual bool UpdateCurrentLoadBalance(const NCallCenterYandex::TAppDistribution& value, const TString& performerId, TMessagesCollector& errors, bool updateCalendar = true) const = 0;

    virtual NThreading::TFuture<std::pair<NCallCenterYandex::EInternalCallProcessResult, TString>> ProcessInternalCall(const NS3::TBucket& bucket, const TString& callId, const bool needCheck = false) const = 0;
};
