#include "entities.h"

#include <rtline/library/json/parse.h>

bool TSupportAICall::DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext) {
    return TPhoneCall::DeserializePhoneWithDecoder(decoder, values, hContext);
}

bool TSupportAICall::DeserializeFromJson(const NJson::TJsonValue& json) {
    if (json.Has("call")) {
        return DoDeserializeFromJson(json["call"], /* requiredCallId = */ true);
    } else if (!json["results"].GetArray().empty()) {
        return DoDeserializeFromJson(json["results"].GetArray().front(), /* requiredCallId = */ false);
    }
    return DoDeserializeFromJson(json, /* requiredCallId = */ false);
}

bool TSupportAICall::DoDeserializeFromJson(const NJson::TJsonValue& json, const bool requiredCallId) {
    {
        auto& start = MutableStartTS();
        if (!NJson::ParseField(json, "created", start, /* required =  */ false)) {
            return false;
        }
        if (!start && !NJson::ParseField(json, "timestamp", start, /* required =  */ true)) {
            return false;
        }
        TDuration total = TDuration::Zero();
        if (!NJson::ParseField(json, "total_duration", NJson::Seconds(total), /* required =  */ false)) {
            return false;
        }
        if (total) {
            SetEndTS(start + total);
            TDuration talk = TDuration::Zero();
            if (!NJson::ParseField(json, "talk_duration", NJson::Seconds(talk), /* required =  */ false)) {
                return false;
            }
            if (talk) {
                SetAnswerTS(GetEndTS() - talk);
                SetStatus(EStatus::Servised);
            } else {
                SetStatus(EStatus::NotServised);
            }
        }
    }
    {
        auto& callId = MutableExternalId();
        if (!callId && !NJson::ParseField(json, "id", callId, /* required =  */ requiredCallId)) {
            return false;
        }
    }
    return NJson::ParseField(json, "phone", MutablePhone(), /* required =  */ true);
}
