#pragma once

#include <drive/backend/support_center/common/entities.h>


class TSupportAICall : public TPhoneCall {
public:
    using TDecoder = TPhoneCall::TDecoder;

public:
    static TString GetTableName() {
        return "call_center_support_ai_calls";
    }

    static TString GetHistoryTableName() {
        return "call_center_support_ai_calls_history";
    }

    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext);
    bool DeserializeFromJson(const NJson::TJsonValue& data) override;

private:
    bool DoDeserializeFromJson(const NJson::TJsonValue& data, const bool requiredCallId);
};
