#include "manager.h"


TString TSupportAICallConditionConstructor::BuildCondition(const TSet<TSupportAICall::TId>& ids, NDrive::TEntitySession& session) {
    return "id IN (" + session->Quote(ids) + ")";
}

NStorage::TTableRecord TSupportAICallConditionConstructor::BuildCondition(const TSupportAICall::TId& id) {
    NStorage::TTableRecord trCondition;
    trCondition.Set("id", id);
    return trCondition;
}

NStorage::TTableRecord TSupportAICallConditionConstructor::BuildCondition(const TSupportAICall& object) {
    return BuildCondition(object.GetId());
}
