#pragma once

#include "entities.h"

#include <drive/backend/database/history/db_entities.h>


class TSupportAICallConditionConstructor {
public:
    static TString BuildCondition(const TSet<TSupportAICall::TId>& ids, NDrive::TEntitySession& session);
    static NStorage::TTableRecord BuildCondition(const TSupportAICall::TId& id);
    static NStorage::TTableRecord BuildCondition(const TSupportAICall& object);
};

class TSupportAICallManager: public TDatabaseEntitiesManager<TSupportAICall, TSupportAICallConditionConstructor> {
private:
    using TBase = TDatabaseEntitiesManager<TSupportAICall, TSupportAICallConditionConstructor>;

public:
    using TBase::TBase;
};
