#include "entities.h"

#include <rtline/library/json/parse.h>

const TSet<TWebPhoneCall::EStatus> TWebPhoneCall::NeedSyncStatuses = { TWebPhoneCall::EStatus::Initialized, TWebPhoneCall::EStatus::Completed };

bool TWebPhoneCall::DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext) {
    return TPhoneCall::DeserializePhoneWithDecoder(decoder, values, hContext);
}

bool TWebPhoneCall::DeserializeFromJson(const NJson::TJsonValue& json) {
    if (json.Has("CODEC")) {
        MutableMeta()["codec"] = json["CODEC"];
    }
    return
           NJson::ParseField(json, "DN", MutablePhone(), /* required =  */ true)
        && NJson::ParseField(json, "TIMESTAMP", MutableStartTS(), /* required =  */ true)
        && NJson::ParseField(json, "ANSWEREDTIME", MutableAnswerTS(), /* required =  */ true)
        && NJson::ParseField(json, "HUPTIME", MutableEndTS(), /* required =  */ true)
        && NJson::ParseField(json, "GUID", MutableExternalId(), /* required =  */ true);
}

TString TWebPhoneCall::GetCodec() const {
    if (GetMeta().Has("codec")) {
        return GetMeta()["codec"].GetStringRobust();
    }
    return "wav";
}
