#pragma once

#include <drive/backend/support_center/common/entities.h>


class TWebPhoneCall : public TPhoneCall {
public:
    using TDecoder = TPhoneCall::TDecoder;
    static const TSet<TWebPhoneCall::EStatus> NeedSyncStatuses;

public:
    static TString GetTableName() {
        return "call_center_webphone_calls";
    }

    static TString GetHistoryTableName() {
        return "call_center_webphone_calls_history";
    }

    TString GetCodec() const;
    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext);
    bool DeserializeFromJson(const NJson::TJsonValue& data) override;
};
