#pragma once

#include "constants.h"

#include <drive/backend/data/support_tags.h>
#include <drive/backend/database/drive_api.h>

class ISupportTelephonyIncomingEvent {
public:
    using ECallCenter = ESupportTelephonyCallCenter;
    using EType = ESupportTelephonyIncomingEventType;

    virtual bool Apply(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const = 0;
    virtual bool Construct(const TString& userId, const NJson::TJsonValue& raw);

protected:
    virtual bool ProcessPerformerCallTags(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;

    virtual TMaybe<TDBTag> HandleActualUserCallTag(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession, bool create) const;
    virtual std::tuple<bool, TMaybe<TDBTag>> ProcessUserCallTags(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;
    virtual std::tuple<bool, TMaybe<TDBTag>> AddUserCallTag(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;

    virtual TAtomicSharedPtr<TSupportPhoneCallTag> ConstructTag(const NDrive::IServer* server) const;
    virtual TAtomicSharedPtr<TSupportPhoneCallTag> ConstructTagByQueue(const NDrive::IServer* server) const;
    virtual TAtomicSharedPtr<TSupportPhoneCallTag> ConstructTagByCallCenter(const NDrive::IServer* server) const;

    virtual TVector<TString> GetTelephonyTagNames(const NDrive::IServer* server) const;
    virtual std::tuple<bool, TMaybe<TDBTag>, TVector<TDBTag>> GetUserCallTags(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;

private:
    R_READONLY(ECallCenter, CCType);
    R_READONLY(TString, UserId);
    R_READONLY(TString, Performer);
    R_READONLY(TString, InternalCallId);
    R_READONLY(TString, Queue);
    R_READONLY(EType, Type, EType::Start);
};

class TSupportTelephonyEvent: public ISupportTelephonyIncomingEvent {
public:
    virtual bool Apply(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const override;

private:
    bool StartCall(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;
    bool SetCallPerformer(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;
    bool DropCallPerformer(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;
    bool FinishCall(const NDrive::IServer* server, NDrive::TEntitySession& tagsSession) const;
};
