#pragma once

#include "config.h"
#include "logger.h"
#include "request.h"

#include <rtline/library/deprecated/async_impl/client.h>

namespace NCallCenterYandex {
    class TResponseCallback : public TRequestCallback<ECallCenterYandexOperationType, TCallCenterYandexLogger> {
        using TBase = TRequestCallback<ECallCenterYandexOperationType, TCallCenterYandexLogger>;

    public:
        TResponseCallback(NJson::TJsonValue& result, ui32& code, TString& errorMessage, const ECallCenterYandexOperationType type, const TCallCenterYandexLogger& logger)
            : TBase(result, code, errorMessage, type, logger)
        {
        }

        virtual void ProcessResponseData() override;
    };

    class TCallCenterYandexClient : public TRequestClient<TCallCenterYandexClientConfig, TCallCenterYandexLogger, ECallCenterYandexOperationType, TResponseCallback> {
        using TBase = TRequestClient<TCallCenterYandexClientConfig, TCallCenterYandexLogger, ECallCenterYandexOperationType, TResponseCallback>;

    public:
        TCallCenterYandexClient(const TCallCenterYandexClientConfig& config)
            : TBase(config, "call-center-yandex-api")
        {
        }

        bool GetStat(const TInstant& since, const TInstant& until, const TVector<TString>& queues, TStatResponse& result, TMessagesCollector& errors) const;

        bool GetAppDistributionInfo(const TString& applicationName, NJson::TJsonValue& result, TMessagesCollector& errors) const;
        bool GetAppDistributionInfo(const TString& applicationName, TAppDistribResponse& result, TMessagesCollector& errors) const;
        bool UpdateAppDistribution(const TAppDistribution& distribution, TMessagesCollector& errors) const;
        bool UpdateAppLoadBalance(const TAppDistribution& distribution, TMessagesCollector& errors) const;

        bool GetAppPlaybackInfo(const TString& applicationName, TAppPlayback& result, TMessagesCollector& errors) const;
        bool UpdateAppPlayback(const TAppPlayback& appPlayback, TMessagesCollector& errors, NJson::TJsonValue* reply = nullptr) const;

        // use standalone routing rules only
        bool GetCallerRoutingInfo(const TString& queueName, const TMaybe<TString>& number, TStandaloneSourceRoutingGetResponse& result, TMessagesCollector& errors) const;
        bool EnableCallerQueueRouting(const TString& queueName, const TString& number, const TString& targetQueueName, TMessagesCollector& errors) const;
        bool EnableCallerNumberRouting(const TString& queueName, const TString& number, const TString& targetNumber, TMessagesCollector& errors) const;
        bool EnableCallerDrop(const TString& queueName, const TString& number, TMessagesCollector& errors) const;
        bool DisableCallerRouting(const TString& queueName, const TString& number, TMessagesCollector& errors) const;

        bool GetAgentState(const TString& agentId, TAgentStateGetResponse& result, TMessagesCollector& errors) const;
        bool ConnectAgent(const TString& agentId, const TVector<TString>& queues, TMessagesCollector& errors, bool paused = false) const;
        bool DisconnectAgent(const TString& agentId, const TVector<TString>& queues, TMessagesCollector& errors) const;
        bool ChangeStatus(const TString& agentId, const TVector<TString>& queues, TMessagesCollector& errors, const bool paused, const ui32 priority = TAgentConnectRequest::DefaultPriority) const;

    private:
        NNeh::THttpRequest& PrepareRequest(NNeh::THttpRequest& req, const bool useRobot = true) const;
        TString PrepareCallerNumber(const TString& number) const;
    };

    enum class EInternalCallProcessResult {
        CallCenterError = 0     /* "call_center_error" */,
        MdsError = 1            /* "mds_error" */,
        Ok = 2                  /* "ok" */,
    };

    class TInternalCallCenterClient {
    public:
        TInternalCallCenterClient(const TInternalCallCenterConfig& config);
        NThreading::TFuture<NNeh::THttpRequest> GetTrackRequest(const TString& callId) const;
        NThreading::TFuture<TString> LoadTrack(const TString& callId) const;
        TDuration GetRequestTimeout() const;

        static NNeh::THttpRequest MakeRawTrackRequest(const TString& context, const TString& mediaUri, const TString& callId);

    private:
        TInternalCallCenterConfig Config;
        TAtomicSharedPtr<NNeh::THttpClient> Client;
    };
};
