#pragma once

#include <rtline/library/deprecated/async_impl/config.h>

class IServerBase;

class TMessagesCollector;

namespace NDrive {
    class TScheme;
}

namespace NJson {
    class TJsonValue;
}

namespace NCallCenterYandex {
    class TCallCenterYandexQueueConfig {
    public:
        static TMaybe<TCallCenterYandexQueueConfig> Construct(const NJson::TJsonValue& data = {});

        static NDrive::TScheme GetScheme(const IServerBase& server);
        static NJson::TJsonValue GetSettingDefaults();
        bool DeserializeFromJson(const NJson::TJsonValue& data);
        NJson::TJsonValue SerializeToJson() const;

        TSet<TString> GetAllQueues() const;
        bool AreQueuesValid(const TSet<TString>& queues, TMessagesCollector& errors) const;

    private:
        static const TString SettingPrefix;

        R_READONLY(TVector<TString>, OrdinaryQueues);
        R_READONLY(TVector<TString>, ExtraQueues);
    };

    class TCallCenterYandexClientConfig: public TTokenAuthRequestConfig {
        using TBase = TTokenAuthRequestConfig;

    public:
        static TCallCenterYandexClientConfig ParseFromString(const TString& configStr) {
            return TBase::ParseFromString<TCallCenterYandexClientConfig>(configStr);
        }

        void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
        void ToString(IOutputStream& os) const;
        void Authorize(NNeh::THttpRequest& request) const;

    private:
        TString GetDefaultHost() const;

    private:
        static const TString DefaultUsername;

        R_READONLY(TString, Username, DefaultUsername);
        R_READONLY(bool, UseDevEnv, false);
    };

    class TInternalCallCenterConfig {
    public:
        void Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;

    private:
        R_READONLY(TString, Uri, "https://tel.yandex-team.ru/");
        R_READONLY(TString, CallRecUri, "queuemetricscallrec");
        R_READONLY(TString, CallMediaUri, "queuemetricscallmedia");
        R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(5));
    };
};
