#include "entities.h"

#include <rtline/library/json/parse.h>

const TSet<TCiptCallEvent::EAction> TCiptCallEvent::ServicedActions = {
    TCiptCallEvent::EAction::AttendedTransfer
    , TCiptCallEvent::EAction::BlindTransfer
    , TCiptCallEvent::EAction::CompleteAgent
    , TCiptCallEvent::EAction::CompleteCaller
};

TCiptCallEvent::TDecoder::TDecoder(const TMap<TString, ui32>& decoderBase) {
    Id = GetFieldDecodeIndex("id", decoderBase);
    EventTS = GetFieldDecodeIndex("time_id", decoderBase);
    Action = GetFieldDecodeIndex("verb", decoderBase);
    CallId = GetFieldDecodeIndex("call_id", decoderBase);
    Phone = GetFieldDecodeIndex("phone", decoderBase);
    QueueName = GetFieldDecodeIndex("queue_name", decoderBase);
    Agent = GetFieldDecodeIndex("agent", decoderBase);
    UserId = GetFieldDecodeIndex("user_binding_id", decoderBase);
    CallCenterStaffId = GetFieldDecodeIndex("staff_entry_binding_id", decoderBase);
}

bool TCiptCallEvent::DeserializeWithDecoder(const TCiptCallEvent::TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
    READ_DECODER_VALUE(decoder, values, Id);
    READ_DECODER_VALUE_INSTANT_ISOFORMAT_OPT(decoder, values, EventTS);
    if (!EventTS) {
        return false;
    }
    READ_DECODER_VALUE(decoder, values, Action);
    READ_DECODER_VALUE(decoder, values, CallId);
    READ_DECODER_VALUE_DEF(decoder, values, Phone, Phone);
    READ_DECODER_VALUE(decoder, values, QueueName);
    READ_DECODER_VALUE_DEF(decoder, values, Agent, Agent);
    READ_DECODER_VALUE_DEF(decoder, values, UserId, UserId);
    READ_DECODER_VALUE_DEF(decoder, values, CallCenterStaffId, CallCenterStaffId);
    return true;
}

bool TCiptCallEvent::Parse(const NStorage::TTableRecord& row) {
    return TBaseDecoder::DeserializeFromTableRecord(*this, row);
}
