#pragma once

#include <rtline/library/storage/structured.h>
#include <rtline/util/types/accessor.h>


class TPrioritizedUser {
    R_READONLY(TString, UserId);

public:
    NStorage::TTableRecord SerializeToTableRecord() const {
        NStorage::TTableRecord result;
        result.Set("user_id", UserId);
        return result;
    }

    bool Parse(const NStorage::TTableRecord& row) {
        UserId = row.Get("user_id");
        return true;
    }
};


class TCiptCallEvent {
public:
    enum class EAction {
        AddMember = 0 /* "ADDMEMBER" */,
        RemoveMember = 1 /* "REMOVEMEMBER" */,
        EnterQueue = 2 /* "ENTERQUEUE" */,
        Abandon = 3 /* "ABANDON" */,
        ExitEmpty = 4 /* "EXITEMPTY" */,
        ExitWithTimeout = 5 /* "EXITWITHTIMEOUT" */,
        Connect = 6 /* "CONNECT" */,
        RingNoAnswer = 7 /* "RINGNOANSWER" */,
        CompleteAgent = 8 /* "COMPLETEAGENT" */,
        CompleteCaller = 9 /* "COMPLETECALLER" */,
        AttendedTransfer = 10 /* "ATTENDEDTRANSFER" */,
        BlindTransfer = 11 /* "BLINDTRANSFER" */,
    };

    static const TSet<TCiptCallEvent::EAction> ServicedActions;

private:
    R_READONLY(ui64, Id, 0);
    R_FIELD(TInstant, EventTS, TInstant::Zero());
    R_FIELD(EAction, Action);
    R_FIELD(TString, CallId);

    R_FIELD(TString, Phone);
    R_FIELD(TString, QueueName);
    R_FIELD(TString, Agent);
    R_FIELD(TString, UserId);
    R_FIELD(ui64, CallCenterStaffId, 0);

public:
    using TId = ui64;
    class TDecoder : public TBaseDecoder {
        R_FIELD(i32, Id, -1);
        R_FIELD(i32, EventTS, -1);
        R_FIELD(i32, Action, -1);
        R_FIELD(i32, CallId, -1);
        R_FIELD(i32, Phone, -1);
        R_FIELD(i32, QueueName, -1);
        R_FIELD(i32, Agent, -1);
        R_FIELD(i32, UserId, -1);
        R_FIELD(i32, CallCenterStaffId, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase);
    };

public:
    TId GetInternalId() const {
        return Id;
    }

    static TString GetTableName() {
        return "call_center_stats";
    }

    bool operator!() const {
        return false;
    }

    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);
    bool Parse(const NStorage::TTableRecord& row);
};
