#pragma once

#include <rtline/library/deprecated/async_impl/logger.h>

namespace NCallCenterYandex {
    enum class ECallCenterYandexOperationType {
        GetStat /* "get_stat" */,

        GetAppDistributionInfo /* "get_app_distribution_info" */,
        UpdateAppDistribution /* "update_app_distribution" */,
        UpdateAppLoadBalance /* "update_app_load_balance" */,

        GetRountingInfo /* "get_routing_info" */,
        EnableQueueRouting /* "enable_queue_routing" */,
        EnableNumberRouting /* "enable_number_routing" */,
        EnableDrop /* "enable_drop" */,
        DisableRouting /* "disable_routing" */,

        GetAgentState /* "get_agent_state" */,
        ConnectAgent /* "connect_agent" */,
        DisconnectAgent /* "disconnect_agent" */,
        ChangeStatus /* "change_status" */,

        GetAppPlaybackInfo /* "get_app_playback_info" */,
        UpdateAppPlayback /* "update_app_playback" */,
    };

    class TCallCenterYandexLogger : public TRequestLogger<ECallCenterYandexOperationType> {
        using TBase = TRequestLogger<ECallCenterYandexOperationType>;

    public:
        TCallCenterYandexLogger(const TString& source)
            : TBase(source, "call-center-api")
        {
        }
    };
};
