#include "manager.h"

#include <util/string/vector.h>


TCiptCallEventsReader::TCiptCallEventsReader(NStorage::IDatabase::TPtr database)
    : TBase(database)
{
}

TString TCiptCallEventsReader::GetTableName() const {
    return TCiptCallEvent::GetTableName();
}

TCiptCallEvent::TId TCiptCallEventsReader::GetMainId(const TCiptCallEvent& e) const {
    return e.GetId();
}

TMaybe<TVector<TCiptCallEvent>> TCiptCallEventsReader::GetObjects(NDrive::TEntitySession& session, const TRange<TInstant> timeRanage, const TRange<TCiptCallEvent::TId> eventIdRange, const TSet<TCiptCallEvent::EAction>& filterActions, const ui32 limit, const bool descending) const {
    TVector<TString> conditions;
    if (timeRanage.From) {
        conditions.push_back("time_id >= '" + timeRanage.From->FormatLocalTime("%Y-%m-%d %H:%M:%S") + "+3'");
    }
    if (timeRanage.To) {
        conditions.push_back("time_id <= '" + timeRanage.To->FormatLocalTime("%Y-%m-%d %H:%M:%S") + "+3'");
    }
    if (eventIdRange.From) {
        conditions.push_back("id > " + ToString(eventIdRange.From));
    }
    if (eventIdRange.To) {
        conditions.push_back("id <= " + ToString(eventIdRange.To));
    }
    TString customCond = JoinStrings(conditions.begin(), conditions.end(), " AND ");
    NSQL::TQueryOptions options(limit, descending);
    if (customCond) {
        options.AddCustomCondition(customCond);
    }
    if (!filterActions.empty()) {
        TSet<TString> actions;
        Transform(filterActions.begin(), filterActions.end(), std::inserter(actions, actions.begin()), [](auto action) { return ToString(action); });
        options.SetGenericCondition("verb", actions);
    }
    options.MutableOrderBy().push_back("id");
    return Fetch(session, options);
}
