#pragma once

#include "entities.h"

#include <drive/backend/database/entity/manager.h>


class TLegacyPriorityManager: public TCachedEntityManager<TPrioritizedUser> {
private:
    using TBase = TCachedEntityManager<TPrioritizedUser>;
    using TEntity = TPrioritizedUser;

public:
    using TBase::TBase;

    virtual TString GetTableName() const override {
        return "call_priority_user";
    }

    virtual TString GetColumnName() const override {
        return "user_id";
    }

    virtual TString GetMainId(const TPrioritizedUser& e) const override {
        return ToString(e.GetUserId());
    }

    bool IsPrioritized(const TString& userId) const {
        auto fetchResult = GetCachedOrFetch(userId);
        return !fetchResult.empty();
    }
};


class TCiptCallEventsReader : public TDatabaseEntityManager<TCiptCallEvent, /* OneToOne = */ true, /* TKey = */ TCiptCallEvent::TId> {
    using TBase = TDatabaseEntityManager<TCiptCallEvent, /* OneToOne = */ true, /* TKey = */ TCiptCallEvent::TId>;

public:
    TCiptCallEventsReader(NStorage::IDatabase::TPtr database);
    virtual TString GetTableName() const override;
    TCiptCallEvent::TId GetMainId(const TCiptCallEvent& e) const override;
    TMaybe<TVector<TCiptCallEvent>> GetObjects(NDrive::TEntitySession& session, const TRange<TInstant> timeRanage, const TRange<TCiptCallEvent::TId> eventIdRange, const TSet<TCiptCallEvent::EAction>& filterActions, const ui32 limit, const bool descending) const;
};
