#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <rtline/util/json_processing.h>
#include <rtline/util/algorithm/container.h>

#include <util/string/join.h>

void TSurgeActivationConfig::FillScheme(NDrive::TScheme& scheme) {
    scheme.Add<TFSBoolean>("surge_enabled", "Сурдж для тарифа включен").SetDefault(false);
    scheme.Add<TFSNumeric>("max_duration_drop_price", "Время простоя для окончания сброса цены (секунды)").SetMin(0).SetMax(1000000).SetDefault(TDuration::Hours(6).Seconds());
    scheme.Add<TFSNumeric>("min_duration_drop_price", "Время простоя для начала сброса цены (секунды)").SetMin(0).SetMax(1000000).SetDefault(TDuration::Hours(4).Seconds());

    scheme.Add<TFSNumeric>("negative_surge_fees_fraction", "Максимальная коррекция цены вниз (доля)").SetMin(0).SetMax(1).SetPrecision(2).SetDefault(0);
    scheme.Add<TFSNumeric>("eq_riding_price", "Равновесная цена минуты riding").SetMin(0).SetMax(10000).SetDefault(800);
    scheme.Add<TFSNumeric>("eq_parking_price", "Равновесная цена минуты parking").SetMin(0).SetMax(10000).SetDefault(200);

    scheme.Add<TFSNumeric>("surge_min", "Минимальный порог спроса для включения повышающей коррекции").SetMin(0).SetMax(10).SetPrecision(2).SetDefault(2);
    scheme.Add<TFSNumeric>("surge_max", "Максимальный порог спроса для включения повышающей коррекции").SetMin(0).SetMax(10).SetPrecision(2).SetDefault(5);

    scheme.Add<TFSNumeric>("positive_surge_fees_fraction", "Максимальная коррекция цены вверх (доля)").SetMin(0).SetMax(1).SetPrecision(2).SetDefault(0);
}

bool TSurgeActivationConfig::DeserializeFromJson(const NJson::TJsonValue& jsonValue) {
    JREAD_DOUBLE_OPT(jsonValue, "surge_min", SurgeMin);
    JREAD_DOUBLE_OPT(jsonValue, "surge_max", SurgeMax);
    JREAD_DOUBLE_OPT(jsonValue, "positive_surge_fees_fraction", PSurgeFeesFraction);
    JREAD_DOUBLE_OPT(jsonValue, "negative_surge_fees_fraction", NSurgeFeesFraction);
    JREAD_UINT_OPT(jsonValue, "eq_riding_price", EquilibriumRidingPrice);
    JREAD_UINT_OPT(jsonValue, "eq_parking_price", EquilibriumParkingPrice);
    JREAD_BOOL_OPT(jsonValue, "surge_enabled", SurgeEnabled);
    JREAD_DURATION_OPT(jsonValue, "min_duration_drop_price", MinDurationDropPrice);
    JREAD_DURATION_OPT(jsonValue, "max_duration_drop_price", MaxDurationDropPrice);

    if (SurgeMin >= SurgeMax) {
        return false;
    }
    return true;
}

void TSurgeActivationConfig::SerializeToJson(NJson::TJsonValue& jsonValue) const {
    JWRITE(jsonValue, "surge_min", SurgeMin);
    JWRITE(jsonValue, "surge_max", SurgeMax);
    JWRITE(jsonValue, "positive_surge_fees_fraction", PSurgeFeesFraction);
    JWRITE(jsonValue, "negative_surge_fees_fraction", NSurgeFeesFraction);
    JWRITE(jsonValue, "eq_riding_price", EquilibriumRidingPrice);
    JWRITE(jsonValue, "eq_parking_price", EquilibriumParkingPrice);
    JWRITE(jsonValue, "surge_enabled", SurgeEnabled);
    JWRITE_DURATION(jsonValue, "min_duration_drop_price", MinDurationDropPrice);
    JWRITE_DURATION(jsonValue, "max_duration_drop_price", MaxDurationDropPrice);
}

void TSurgeConstructorConfig::Init(const TYandexConfig::Section* section) {
    RTLineAPIName = section->GetDirectives().Value("RTLineAPIName", RTLineAPIName);
    AssertCorrectConfig(!!RTLineAPIName, "Incorrect RTLineAPIName field in config for SurgeConstructor");
    CarRouterAPI = section->GetDirectives().Value("CarRouterAPI", CarRouterAPI);
    AssertCorrectConfig(!!CarRouterAPI, "Incorrect CarRouterAPI field in config for SurgeConstructor");
    NightDurationLimit = section->GetDirectives().Value("NightDurationLimit", NightDurationLimit);
    EffectiveDuration = section->GetDirectives().Value("EffectiveDuration", EffectiveDuration);
    LocationFreshness = section->GetDirectives().Value("LocationFreshness", LocationFreshness);
    Livetime = section->GetDirectives().Value("Livetime", Livetime);
    RevenueDistributionFreshness = section->GetDirectives().Value("RevenueDistributionFreshness", RevenueDistributionFreshness);
    TVector<TString> tagNames;
    section->GetDirectives().FillArray("TagNames", tagNames);
    TagNames = MakeSet(tagNames);
    if (TagNames.empty()) {
        TagNames.emplace("class_base");
    }
}

void TSurgeConstructorConfig::ToString(IOutputStream& os) const {
    os << "RTLineAPIName: " << RTLineAPIName << Endl;
    os << "CarRouterAPI: " << CarRouterAPI << Endl;
    os << "EffectiveDuration: " << EffectiveDuration << Endl;
    os << "Livetime: " << Livetime << Endl;
    os << "LocationFreshness: " << LocationFreshness << Endl;
    os << "TagNames: " << JoinSeq(",", TagNames) << Endl;
    os << "NightDurationLimit: " << NightDurationLimit << Endl;
    os << "RevenueDistributionFreshness: " << RevenueDistributionFreshness << Endl;
}
