#pragma once

#include <drive/library/cpp/scheme/scheme.h>

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/yconf/conf.h>

#include <rtline/util/types/accessor.h>

#include <util/datetime/base.h>
#include <util/generic/set.h>

class TSurgeActivationConfig {
    R_READONLY(double, SurgeMin, 2);
    R_READONLY(double, SurgeMax, 5);
    R_READONLY(double, PSurgeFeesFraction, 0);
    R_READONLY(double, NSurgeFeesFraction, 0);
    R_READONLY(ui32, EquilibriumRidingPrice, 800);
    R_READONLY(ui32, EquilibriumParkingPrice, 200);
    R_FIELD(bool, SurgeEnabled, false);
    R_READONLY(TDuration, MinDurationDropPrice, TDuration::Hours(4));
    R_READONLY(TDuration, MaxDurationDropPrice, TDuration::Hours(6));

public:
    static void FillScheme(NDrive::TScheme& scheme);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& jsonValue);
    void SerializeToJson(NJson::TJsonValue& jsonValue) const;
};

class TSurgeConstructorConfig {
private:
    R_READONLY(TString, RTLineAPIName);
    R_READONLY(TString, CarRouterAPI, "drive_router");
    R_READONLY(TDuration, EffectiveDuration, TDuration::Minutes(15));
    R_READONLY(TDuration, Livetime, TDuration::Minutes(2));
    R_READONLY(TDuration, LocationFreshness, TDuration::Hours(8));
    R_READONLY(TDuration, NightDurationLimit, TDuration::Hours(11));
    R_READONLY(TDuration, RevenueDistributionFreshness, TDuration::Minutes(1));

    R_READONLY(ui32, StoreMaxInFlight, 200);
    R_READONLY(TDuration, StoreTimeout, TDuration::Seconds(20));

    R_READONLY(TSet<TString>, TagNames);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
