#include "abstract.h"

#include <rtline/library/json/adapters.h>

template <>
NJson::TJsonValue NJson::ToJson(const NEntityTagsManager::EEntityType& object) {
    return NJson::ToJson(NJson::Stringify(object));
}

template <>
NJson::TJsonValue NJson::ToJson(const NTagActions::ETagAction& object) {
    return NJson::ToJson(NJson::Stringify(object));
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NEntityTagsManager::EEntityType& result) {
    return NJson::TryFromJson(value, NJson::Stringify(result));
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NTagActions::ETagAction& result) {
    return NJson::TryFromJson(value, NJson::Stringify(result));
}
