#pragma once

#include <util/system/types.h>

namespace NEntityTagsManager {
    enum class EEntityType {
        Car = 0         /* "car" */,
        User = 1        /* "user" */,
        Trace = 2       /* "trace" */,
        Area = 3        /* "area" */,
        Account = 5     /* "account" */,
        Undefined = 100 /* "undefined" */,
    };

    enum class EMultiplePerformersPolicy {
        Allow,
        Deny,
    };
}

namespace NTagActions {
    using TTagActions = ui32;

    enum class ETagAction: TTagActions {
        Add = 1 << 0 /* "add" */,
        Remove = 1 << 1 /* "remove" */,
        Observe = 1 << 2 /* "observe" */,
        Perform = 1 << 3 /* "perform" */,
        ObserveObject = 1 << 4 /* "observe_object" */,
        ObserveObjectsOnPerform = 1 << 5 /* "observe_objects_on_perform" */,
        ObserveOnPerformByAnother = 1 << 6 /* "observe_on_perform_by_another" */,
        ForcePerform = 1 << 7 /* "force_perform" */,
        DropPerform = 1 << 8 /* "drop_perform" */,
        RemovePerform = 1 << 9 /* "remove_perform" */,
        HideObject = 1 << 10 /* "hide_object" */,
        Update = 1 << 11 /* "update" */,
        UpdateOnPerform = 1 << 12 /* "update_on_perform" */,
        UpdateOnPerformByAnother = 1 << 13 /* "update_on_perform_by_another" */,
        Propose = 1 << 14 /* "propose" */,
        Reject = 1 << 15 /* "reject" */,
        Confirm = 1 << 16 /* "confirm" */,
        AssigneeToPerform = 1 << 17 /* "assignee_to_perform" */,
        ForceObserveObject = 1 << 18 /* "force_observe_object" */,
        ObserveBusyObject = 1 << 19 /* "observe_busy_object" */,
        HideSelfPerformObject = 1 << 20 /* "hide_self_perform_object" */,
        UpdateObject = 1 << 21 /* "update_object" */,
    };
}
