#include "config.h"

void TTagsManagerConfig::ToString(IOutputStream& os) const {
    os << "<DeviceTagsHistory>" << Endl;
    DeviceTagsHistoryConfig.ToString(os);
    os << "</DeviceTagsHistory>" << Endl;

    os << "<DeviceTagPropositions>" << Endl;
    DeviceTagPropositionsConfig.ToString(os);
    os << "</DeviceTagPropositions>" << Endl;

    os << "<TagDescriptionsHistory>" << Endl;
    TagDescriptionsHistoryConfig.ToString(os);
    os << "</TagDescriptionsHistory>" << Endl;

    os << "<TagDescriptionsPropositions>" << Endl;
    TagDescriptionsPropositionsConfig.ToString(os);
    os << "</TagDescriptionsPropositions>" << Endl;

    os << "<UserTagsHistory>" << Endl;
    UserTagsHistoryConfig.ToString(os);
    os << "</UserTagsHistory>" << Endl;

    os << "TagDescriptionsFreshness: " << TagDescriptionsFreshness << Endl;
    os << "TagsDBName: " << TagsDBName << Endl;
}

void TTagsManagerConfig::Init(const TYandexConfig::Section* section) {
    auto children = section->GetAllChildren();
    {
        auto it = children.find("TagDescriptionsHistory");
        if (it != children.end()) {
            TagDescriptionsHistoryConfig.Init(it->second);
        }
    }

    {
        auto it = children.find("TagDescriptionsPropositions");
        if (it != children.end()) {
            TagDescriptionsPropositionsConfig.Init(it->second);
        }
    }

    {
        auto it = children.find("DeviceTagsHistory");
        if (it == children.end()) {
            DeviceTagsHistoryConfig.SetDeep(TDuration::Days(21));
        } else {
            DeviceTagsHistoryConfig.Init(it->second);
        }
    }

    {
        auto it = children.find("DeviceTagPropositions");
        if (it != children.end()) {
            DeviceTagPropositionsConfig.Init(it->second);
        }
    }
    {
        auto it = children.find("UserTagsHistory");
        if (it == children.end()) {
            UserTagsHistoryConfig.SetDeep(TDuration::Days(21));
        } else {
            UserTagsHistoryConfig.Init(it->second);
        }
    }

    TagDescriptionsFreshness = section->GetDirectives().Value("TagDescriptionsFreshness", TagDescriptionsFreshness);
    TagsDBName = section->GetDirectives().Value("TagsDBName", TagsDBName);
}
